/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import uk.ac.man.bioinf.sequence.DefaultSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.DefaultGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.complex.AbstractComplexSequence;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexSequenceType;
import uk.ac.man.bioinf.sequence.complex.GappedComplexSequence;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.util.IntArrayList;

public class DefaultGappedComplexSequence
extends AbstractComplexSequence
implements GappedComplexSequence {
    private DisabledDefaultGappedSequence gappedSequence;
    private ComplexElement[] elements;

    public DefaultGappedComplexSequence(Element[] elementArray, ComplexSequenceType complexSequenceType) {
        super(complexSequenceType);
        IntArrayList intArrayList = DefaultGappedSequence.getGapModelForElements(elementArray);
        Sequences.printElements(elementArray);
        System.out.println(intArrayList.get(intArrayList.size() - 1));
        Residue[] residueArray = DefaultGappedSequence.stripGapsFromElements(elementArray, intArrayList.get(0));
        Element[] elementArray2 = Sequences.getResiduesAsComplexElements(residueArray);
        this.elements = elementArray2;
        DefaultSequence defaultSequence = new DefaultSequence(elementArray2, null){

            public void checkSequenceType(Element[] elementArray) throws InvalidSequenceTypeException {
            }
        };
        this.gappedSequence = new DisabledDefaultGappedSequence(defaultSequence, intArrayList);
    }

    public ComplexElement getComplexElementAt(int n) {
        return (ComplexElement)this.gappedSequence.getElementAt(n);
    }

    public Element getElementAt(int n) {
        return this.getComplexElementAt(n).getResidue();
    }

    public Element getGappedElementAt(int n) {
        int n2 = this.gappedSequence.getUngappedPositionOf(n);
        if (n2 < 1) {
            return Gap.GAP;
        }
        return this.getElementAt(n2);
    }

    public ComplexElement[] getSequenceAsComplexElements() {
        Element[] elementArray = this.gappedSequence.getSequenceAsElements();
        ComplexElement[] complexElementArray = new ComplexElement[elementArray.length];
        System.arraycopy(elementArray, 0, complexElementArray, 0, elementArray.length);
        return complexElementArray;
    }

    protected ComplexElement setElementAtQuietly(ComplexElement complexElement, int n) {
        this.checkComplexSequenceType(complexElement);
        this.elements[n - 1] = complexElement;
        return complexElement;
    }

    public Identifier getIdentifier() {
        return this.gappedSequence.getIdentifier();
    }

    public GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        return DisabledDefaultGappedSequence.getElementsAsGappedSequence(elementArray, sequenceType, identifier);
    }

    public GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType) {
        return DisabledDefaultGappedSequence.getElementsAsGappedSequence(elementArray, sequenceType);
    }

    public Element[] getSequenceAsElements() {
        return this.gappedSequence.getSequenceAsElements();
    }

    public int getLength() {
        return this.gappedSequence.getLength();
    }

    public GappedSequence getGappedSubSequence(int n, int n2) {
        return this.gappedSequence.getGappedSubSequence(n, n2);
    }

    public Element[] getGappedSequenceAsElements() {
        return this.gappedSequence.getGappedSequenceAsElements();
    }

    public int getGappedLength() {
        return this.gappedSequence.getGappedLength();
    }

    public int getGappedPositionOf(int n) {
        return this.gappedSequence.getGappedPositionOf(n);
    }

    public int getUngappedPositionOf(int n) {
        return this.gappedSequence.getUngappedPositionOf(n);
    }

    public void insertGapAt(int n) throws SequenceVetoException {
        this.gappedSequence.insertGapAt(n);
    }

    public void insertGapAt(int n, int n2) throws SequenceVetoException {
        this.gappedSequence.insertGapAt(n, n2);
    }

    public void deleteGapAt(int n) throws SequenceVetoException {
        this.gappedSequence.deleteGapAt(n);
    }

    public void deleteGapAt(int n, int n2) throws SequenceVetoException {
        this.gappedSequence.deleteGapAt(n, n2);
    }

    public char getGappedElementAtAsChar(int n) {
        return this.gappedSequence.getGappedElementAtAsChar(n);
    }

    public char[] getGappedSequenceAsChars() {
        return this.gappedSequence.getGappedSequenceAsChars();
    }

    public Sequence getSubSequence(int n, int n2) {
        return this.gappedSequence.getSubSequence(n, n2);
    }

    public char[] getSequenceAsChars() {
        return this.gappedSequence.getSequenceAsChars();
    }

    public char getElementAtAsChar(int n) {
        return this.gappedSequence.getElementAtAsChar(n);
    }

    class DisabledDefaultGappedSequence
    extends DefaultGappedSequence {
        DisabledDefaultGappedSequence(Sequence sequence, IntArrayList intArrayList) {
            super(sequence, intArrayList);
        }

        protected void checkSequenceType(Element element) throws InvalidSequenceTypeException {
        }

        protected void checkSequenceType(Element[] elementArray) throws InvalidSequenceTypeException {
        }
    }
}

