/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.complex.AbstractComplexSequence;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexSequenceType;
import uk.ac.man.bioinf.sequence.identifier.Identifier;

public class DefaultComplexSequence
extends AbstractComplexSequence {
    private ArrayList elements;
    private Identifier ident;

    public DefaultComplexSequence(Residue[] residueArray, ComplexSequenceType complexSequenceType, Identifier identifier) {
        super(complexSequenceType);
        this.checkSequenceType(residueArray);
        this.ident = this.ident;
        ComplexElement[] complexElementArray = Sequences.getResiduesAsComplexElements(residueArray);
        this.elements = new ArrayList<ComplexElement>(Arrays.asList(complexElementArray));
    }

    public DefaultComplexSequence(ComplexElement[] complexElementArray, ComplexSequenceType complexSequenceType, Identifier identifier) {
        super(complexSequenceType);
        this.checkComplexSequenceType(complexElementArray);
        this.ident = this.ident;
        this.elements = new ArrayList<ComplexElement>(Arrays.asList(complexElementArray));
    }

    public Identifier getIdentifier() {
        return this.ident;
    }

    public Element getElementAt(int n) {
        return this.getComplexElementAt(n).getResidue();
    }

    public ComplexElement getComplexElementAt(int n) {
        return (ComplexElement)this.elements.get(n - 1);
    }

    public int getLength() {
        return this.elements.size();
    }

    public ComplexElement[] getSequenceAsComplexElements() {
        Object[] objectArray = this.elements.toArray();
        ComplexElement[] complexElementArray = new ComplexElement[objectArray.length];
        System.arraycopy(objectArray, 0, complexElementArray, 0, objectArray.length);
        return complexElementArray;
    }

    public Element[] getSequenceAsElements() {
        Object[] objectArray = this.elements.toArray();
        Element[] elementArray = new Element[objectArray.length];
        System.arraycopy(objectArray, 0, elementArray, 0, objectArray.length);
        return elementArray;
    }

    protected ComplexElement setElementAtQuietly(ComplexElement complexElement, int n) {
        this.checkComplexSequenceType(complexElement);
        this.elements.set(n - 1, complexElement);
        return complexElement;
    }
}

