/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.sequence.complex.ModificationSet;
import uk.ac.man.bioinf.sequence.complex.ModificationSetFactory;

public class DefaultComplexElement
implements ComplexElement {
    private Residue residue;
    private ModificationSet modifications;

    DefaultComplexElement() {
    }

    public char toChar() {
        return this.residue.toChar();
    }

    void setResidue(Residue residue) {
        this.residue = residue;
    }

    void setModifications(Modification[] modificationArray, Modification modification) {
        this.modifications = ModificationSetFactory.getModificationSet(modificationArray, modification);
    }

    void setModifications(Modification[] modificationArray) {
        this.modifications = ModificationSetFactory.getModificationSet(modificationArray);
    }

    void setModifications(Modification modification) {
        this.modifications = ModificationSetFactory.getModificationSet(modification);
    }

    void setModifications() {
        this.modifications = ModificationSetFactory.getModificationSet();
    }

    public Residue getResidue() {
        return this.residue;
    }

    public Modification[] getModifications() {
        return this.modifications.getModifications();
    }

    public boolean isModified(Modification modification) {
        return this.modifications.containsModification(modification);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultComplexElement)) {
            return false;
        }
        DefaultComplexElement defaultComplexElement = (DefaultComplexElement)object;
        if (defaultComplexElement.residue != this.residue) {
            return false;
        }
        return defaultComplexElement.modifications.equals(this.modifications);
    }

    public int hashCode() {
        return this.residue.hashCode() + this.modifications.hashCode();
    }
}

