/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexElementFactoryInterface;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.sequence.complex.WeakComplexElementFactory;

public class ComplexElementFactory {
    private static ComplexElementFactoryInterface fact = new WeakComplexElementFactory();

    public static void setComplexElementFactory(ComplexElementFactoryInterface complexElementFactoryInterface) {
        fact = complexElementFactoryInterface;
    }

    public static ComplexElement getComplexElement(Residue residue) {
        return fact.getComplexElement(residue);
    }

    public static ComplexElement addComplexElement(Residue residue, Modification modification) {
        return fact.addComplexElement(residue, modification);
    }

    public static ComplexElement addComplexElement(ComplexElement complexElement, Modification modification) {
        return fact.addComplexElement(complexElement, modification);
    }

    public static ComplexElement[] addComplexElement(Residue[] residueArray, Modification[] modificationArray) {
        ComplexElement[] complexElementArray = new ComplexElement[residueArray.length];
        int n = 0;
        while (n < residueArray.length) {
            complexElementArray[n] = fact.addComplexElement(residueArray[n], modificationArray[n]);
            ++n;
        }
        return complexElementArray;
    }

    public static ComplexElement[] addComplexElement(ComplexElement[] complexElementArray, Modification[] modificationArray) {
        ComplexElement[] complexElementArray2 = new ComplexElement[complexElementArray.length];
        int n = 0;
        while (n < complexElementArray.length) {
            complexElementArray2[n] = fact.addComplexElement(complexElementArray[n], modificationArray[n]);
            ++n;
        }
        return complexElementArray2;
    }

    public static ComplexElement removeComplexElement(ComplexElement complexElement, Modification modification) {
        return fact.removeComplexElement(complexElement, modification);
    }
}

