/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import uk.ac.man.bioinf.sequence.AbstractMutableSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexElementFactory;
import uk.ac.man.bioinf.sequence.complex.ComplexSequence;
import uk.ac.man.bioinf.sequence.complex.ComplexSequenceType;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.sequence.event.SequenceEventType;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;

public abstract class AbstractComplexSequence
extends AbstractMutableSequence
implements ComplexSequence {
    private ComplexSequenceType type;

    public AbstractComplexSequence(ComplexSequenceType complexSequenceType) {
        super(complexSequenceType);
        this.type = complexSequenceType;
    }

    public ComplexSequenceType getComplexType() {
        return this.type;
    }

    protected void checkSequenceType(Element[] elementArray) throws InvalidSequenceTypeException {
        int n = 0;
        while (n < elementArray.length) {
            this.checkSequenceType(elementArray[n]);
            ++n;
        }
    }

    protected void checkSequenceType(Element element) throws InvalidSequenceTypeException {
        if (!(element instanceof ComplexElement)) {
            super.checkSequenceType(element);
        } else {
            this.checkComplexSequenceType((ComplexElement)element);
        }
    }

    protected void checkComplexSequenceType(ComplexElement[] complexElementArray) throws InvalidSequenceTypeException {
        int n = 0;
        while (n < complexElementArray.length) {
            this.checkComplexSequenceType(complexElementArray[n]);
            ++n;
        }
    }

    protected void checkComplexSequenceType(ComplexElement complexElement) throws InvalidSequenceTypeException {
        if (!this.type.isAllowableElement(complexElement)) {
            throw this.getComplexSequenceTypeException(complexElement);
        }
    }

    protected InvalidSequenceTypeException getComplexSequenceTypeException(Element element) {
        return new InvalidSequenceTypeException("Element " + element + " is not a valid part of the complex sequence type " + this.type.toString());
    }

    public ComplexElement addModificationAt(Modification modification, int n) throws SequenceVetoException {
        ComplexElement complexElement = this.getComplexElementAt(n);
        ComplexElement complexElement2 = ComplexElementFactory.addComplexElement(complexElement, modification);
        VetoableSequenceEvent vetoableSequenceEvent = new VetoableSequenceEvent(this, n, SequenceEventType.SET);
        this.fireVetoableSequenceEvent(vetoableSequenceEvent);
        this.setElementAtQuietly(complexElement2, n);
        this.fireSequenceEvent(vetoableSequenceEvent);
        return complexElement2;
    }

    protected abstract ComplexElement setElementAtQuietly(ComplexElement var1, int var2);

    public ComplexElement removeModificationAt(Modification modification, int n) throws SequenceVetoException {
        ComplexElement complexElement = this.getComplexElementAt(n);
        ComplexElement complexElement2 = ComplexElementFactory.removeComplexElement(complexElement, modification);
        VetoableSequenceEvent vetoableSequenceEvent = new VetoableSequenceEvent(this, n, SequenceEventType.SET);
        this.fireVetoableSequenceEvent(vetoableSequenceEvent);
        this.setElementAtQuietly(complexElement2, n);
        this.fireSequenceEvent(vetoableSequenceEvent);
        return complexElement2;
    }

    public char[] getComplexElementAtAsChar(int n) {
        ComplexElement complexElement = this.getComplexElementAt(n);
        Modification[] modificationArray = complexElement.getModifications();
        char[] cArray = new char[modificationArray.length + 2];
        cArray[0] = complexElement.toChar();
        int n2 = 0;
        while (n2 < modificationArray.length) {
            cArray[n2 + 1] = modificationArray[n2].toChar();
            ++n2;
        }
        cArray[cArray.length - 1] = 95;
        return cArray;
    }

    public char[] getComplexSequenceAsChars() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getLength()) {
            stringBuffer.append(this.getComplexElementAtAsChar(n + 1));
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }
}

