/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoSuchSequenceException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.alignment.event.VetoableAlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;
import uk.ac.man.bioinf.sequence.types.EmptySequenceType;

public class EmptySequenceAlignment
implements SequenceAlignment {
    private static final EmptySequenceAlignment instance = new EmptySequenceAlignment();
    private static Identifier ident = new NoIdentifier();

    public static EmptySequenceAlignment getInstance() {
        return instance;
    }

    private EmptySequenceAlignment() {
    }

    private NoSuchSequenceException createSequenceException(int n) {
        return new NoSuchSequenceException("Empty sequence does not do much", this, n);
    }

    public int getInset(int n) {
        throw this.createSequenceException(n);
    }

    public int getLength() {
        return 0;
    }

    public int getNumberSequences() {
        return 0;
    }

    public GappedSequence getSequenceAt(int n) {
        throw this.createSequenceException(n);
    }

    public int getSequenceIndex(GappedSequence gappedSequence) {
        return -1;
    }

    public SequenceType getSequenceType() {
        return EmptySequenceType.getInstance();
    }

    public SequenceAlignment getSubAlignment(int n, int n2, int n3, int n4) {
        if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0) {
            throw this.createSequenceException(n);
        }
        return this;
    }

    public SequenceAlignment getSubAlignment(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        return this.getSubAlignment(sequenceAlignmentRectangle.getX(), sequenceAlignmentRectangle.getWidth(), sequenceAlignmentRectangle.getY(), sequenceAlignmentRectangle.getHeight());
    }

    public void setInset(int n, int n2) {
    }

    public void setInsetQuietly(int n, int n2) {
    }

    public void addSequence(GappedSequence gappedSequence, int n) {
    }

    public GappedSequence removeSequence(int n) {
        throw this.createSequenceException(n);
    }

    public void setLengthQuietly(int n) {
    }

    public void addAlignmentListener(AlignmentListener alignmentListener) {
    }

    public void removeAlignmentListener(AlignmentListener alignmentListener) {
    }

    public void addVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
    }

    public void removeVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
    }

    public void vetoableChangeOccurred(VetoableSequenceEvent vetoableSequenceEvent) {
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
    }

    public void addVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
    }

    public void removeVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
    }

    public Identifier getIdentifier() {
        return ident;
    }
}

