/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.DefaultSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.EmptySequence;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.AbstractGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoGapAtThisPositionException;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;
import uk.ac.man.bioinf.util.IntArrayList;

public class DefaultGappedSequence
extends AbstractGappedSequence {
    protected Sequence sequence;
    protected IntArrayList toGappedMap;

    protected DefaultGappedSequence(Sequence sequence, IntArrayList intArrayList) {
        super(sequence.getSequenceType());
        this.sequence = sequence;
        this.toGappedMap = intArrayList;
    }

    protected DefaultGappedSequence(Element[] elementArray, SequenceType sequenceType, IntArrayList intArrayList, Identifier identifier) {
        this(new DefaultSequence(elementArray, sequenceType, identifier), intArrayList);
    }

    public DefaultGappedSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        this(elementArray, sequenceType, new IntArrayList(), identifier);
        this.toGappedMap.add(0, 0);
        int n = 0;
        while (n < elementArray.length) {
            this.toGappedMap.add(n + 1);
            ++n;
        }
    }

    public DefaultGappedSequence(Element[] elementArray, SequenceType sequenceType) {
        this(elementArray, sequenceType, new NoIdentifier());
    }

    protected void deleteGapAtQuietly(int n) {
        this.checkGappedRange(n);
        if (this.getGappedElementAt(n) != Gap.GAP) {
            throw new NoGapAtThisPositionException(this, n);
        }
        this.toGappedMap.remove(n);
    }

    protected void insertGapAtQuietly(int n) {
        this.checkGappedRangeForInsert(n);
        this.toGappedMap.add(n, -1);
    }

    public Element getGappedElementAt(int n) {
        try {
            int n2 = this.toGappedMap.get(n);
            if (n2 < 0) {
                return Gap.GAP;
            }
            return this.sequence.getElementAt(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.getGappedSequenceIndexException(n);
        }
    }

    public Element[] getGappedSequenceAsElements() {
        Element[] elementArray = new Element[this.getGappedLength()];
        int n = 0;
        while (n < elementArray.length) {
            elementArray[n] = this.getGappedElementAt(n + 1);
            ++n;
        }
        return elementArray;
    }

    public int getGappedLength() {
        return this.toGappedMap.size() - 1;
    }

    public int getUngappedPositionOf(int n) {
        this.checkGappedRange(n);
        return this.toGappedMap.get(n);
    }

    public int getGappedPositionOf(int n) {
        this.checkRange(n);
        int n2 = n;
        while (n2 != this.getGappedLength()) {
            if (this.toGappedMap.get(n2) == n) {
                return n2;
            }
            ++n2;
        }
        throw new Error("Failed to find ungapped index which should have been there");
    }

    public GappedSequence getGappedSubSequence(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n + n2 - 1;
        this.checkGappedRange(n4);
        this.checkGappedRange(n5);
        IntArrayList intArrayList = this.toGappedMap.getSubList(n, n2);
        int n6 = n - this.getUngappedPositionOf(n);
        int n7 = n - n6;
        int n8 = 0;
        while (n8 < n2) {
            n3 = intArrayList.get(n8);
            if (n3 > 0) {
                intArrayList.set(n8, n3 - n7 + 1);
            }
            ++n8;
        }
        intArrayList.add(0, 0);
        while (this.getUngappedPositionOf(n4) == -1) {
            ++n4;
        }
        while (this.getUngappedPositionOf(n5) == -1) {
            --n5;
        }
        n3 = n5 - n4 + 1;
        Sequence sequence = n3 < 1 ? EmptySequence.getInstance() : this.sequence.getSubSequence(n4 - n6, n3);
        return new DefaultGappedSequence(sequence, intArrayList);
    }

    public int getLength() {
        return this.sequence.getLength();
    }

    public Identifier getIdentifier() {
        return this.sequence.getIdentifier();
    }

    public Element[] getSequenceAsElements() {
        return this.sequence.getSequenceAsElements();
    }

    public Element getElementAt(int n) {
        return this.sequence.getElementAt(n);
    }

    public static GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType) {
        return DefaultGappedSequence.getElementsAsGappedSequence(elementArray, sequenceType, new NoIdentifier());
    }

    public static GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        IntArrayList intArrayList = DefaultGappedSequence.getGapModelForElements(elementArray);
        Element[] elementArray2 = DefaultGappedSequence.stripGapsFromElements(elementArray, intArrayList.get(0));
        return new DefaultGappedSequence(elementArray2, sequenceType, intArrayList, identifier);
    }

    public static Residue[] stripGapsFromElements(Element[] elementArray, int n) {
        Residue[] residueArray = new Residue[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < elementArray.length) {
            if (elementArray[n3] != Gap.GAP) {
                residueArray[n2++] = (Residue)elementArray[n3];
            }
            ++n3;
        }
        return residueArray;
    }

    public static IntArrayList getGapModelForElements(Element[] elementArray) {
        IntArrayList intArrayList = new IntArrayList(elementArray.length);
        intArrayList.add(0);
        int n = 0;
        int n2 = 0;
        while (n2 < elementArray.length) {
            if (elementArray[n2] == Gap.GAP) {
                intArrayList.add(-1);
            } else {
                intArrayList.add(++n);
            }
            ++n2;
        }
        intArrayList.set(0, n);
        return intArrayList;
    }

    public void debugScreenDump() {
        System.out.println("Internal sequence is ");
        Sequences.printSequence(this.sequence);
        System.out.println("Internal gap model is  ");
        this.toGappedMap.print();
    }
}

