/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEventType;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListenerSupport;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentVetoException;
import uk.ac.man.bioinf.sequence.alignment.event.VetoableAlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.VetoableAlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceEventType;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceListenerSupport;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;

public abstract class AbstractSequenceAlignment
implements SequenceAlignment,
VetoableSequenceListener {
    private AlignmentListenerSupport msls = new AlignmentListenerSupport();
    private SequenceListenerSupport supp = new SequenceListenerSupport();

    protected abstract void setLengthQuietly(int var1);

    protected abstract void addSequenceQuietly(GappedSequence var1, int var2);

    public SequenceAlignment getSubAlignment(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        return this.getSubAlignment(sequenceAlignmentRectangle.getX(), sequenceAlignmentRectangle.getWidth(), sequenceAlignmentRectangle.getY(), sequenceAlignmentRectangle.getHeight());
    }

    public void addSequence(GappedSequence gappedSequence, int n) throws AlignmentVetoException {
        this.msls.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, this.getNumberSequences() + 1, AlignmentEventType.INSERT));
        this.addSequenceQuietly(gappedSequence, n);
        this.ensureLengthIncrease(gappedSequence.getGappedLength() + n, this.getNumberSequences());
        this.msls.fireAlignmentEvent(new AlignmentEvent(this, this.getNumberSequences() + 1, AlignmentEventType.INSERT));
    }

    public void addSequence(SequenceAlignment sequenceAlignment) throws AlignmentVetoException {
        this.msls.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, this.getNumberSequences() + sequenceAlignment.getNumberSequences(), AlignmentEventType.INSERT));
        int n = 0;
        while (n < sequenceAlignment.getNumberSequences()) {
            this.addSequence(sequenceAlignment.getSequenceAt(n), sequenceAlignment.getInset(n));
            ++n;
        }
        this.msls.fireAlignmentEvent(new AlignmentEvent(this, this.getNumberSequences() + sequenceAlignment.getNumberSequences(), AlignmentEventType.INSERT));
    }

    protected abstract GappedSequence removeSequenceQuietly(int var1);

    public GappedSequence removeSequence(int n) throws AlignmentVetoException {
        this.msls.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, n, AlignmentEventType.DELETE));
        GappedSequence gappedSequence = this.removeSequenceQuietly(n);
        this.msls.fireAlignmentEvent(new AlignmentEvent(this, n, AlignmentEventType.DELETE));
        return gappedSequence;
    }

    protected abstract void setInsetQuietly(int var1, int var2);

    public void setInset(int n, int n2) throws AlignmentVetoException {
        if (n2 == this.getInset(n)) {
            return;
        }
        this.msls.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, n, AlignmentEventType.INSET_CHANGE));
        if (n2 > this.getInset(n)) {
            this.ensureLengthIncrease(n2 + this.getSequenceAt(n).getGappedLength(), n);
        } else {
            this.ensureLengthDecrease();
        }
        this.setInsetQuietly(n, n2);
        this.msls.fireAlignmentEvent(new AlignmentEvent(this, n, AlignmentEventType.INSET_CHANGE));
    }

    private void ensureLengthIncrease(int n, int n2) throws AlignmentVetoException {
        if (n > this.getLength()) {
            this.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, n2, AlignmentEventType.LENGTH_CHANGE));
            this.setLengthQuietly(n);
            this.fireAlignmentEvent(new AlignmentEvent(this, n2, AlignmentEventType.LENGTH_CHANGE));
        }
    }

    private void ensureLengthDecrease() throws AlignmentVetoException {
        int n = 0;
        int n2 = 1;
        while (n2 < this.getNumberSequences() + 1) {
            int n3 = this.getSequenceAt(n2).getGappedLength() + this.getInset(n2);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        if (n != this.getLength()) {
            this.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, 0, AlignmentEventType.LENGTH_CHANGE));
            this.setLengthQuietly(n);
            this.fireAlignmentEvent(new AlignmentEvent(this, 0, AlignmentEventType.LENGTH_CHANGE));
        }
    }

    protected void fireAlignmentEvent(AlignmentEvent alignmentEvent) {
        this.msls.fireAlignmentEvent(alignmentEvent);
    }

    protected void fireVetoableAlignmentEvent(VetoableAlignmentEvent vetoableAlignmentEvent) throws AlignmentVetoException {
        this.msls.fireVetoableAlignmentEvent(vetoableAlignmentEvent);
    }

    public void addAlignmentListener(AlignmentListener alignmentListener) {
        if (alignmentListener != null) {
            this.msls.addAlignmentListener(alignmentListener);
        }
    }

    public void removeAlignmentListener(AlignmentListener alignmentListener) {
        if (alignmentListener != null) {
            this.msls.removeAlignmentListener(alignmentListener);
        }
    }

    public void addVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
        if (vetoableAlignmentListener != null) {
            this.addVetoableAlignmentListener(vetoableAlignmentListener);
        }
    }

    public void removeVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
        if (vetoableAlignmentListener != null) {
            this.removeVetoableAlignmentListener(vetoableAlignmentListener);
        }
    }

    private void fireVetoableSequenceEvent(VetoableSequenceEvent vetoableSequenceEvent) throws SequenceVetoException {
        this.supp.fireVetoableSequenceEvent(vetoableSequenceEvent);
    }

    private void fireSequenceEvent(SequenceEvent sequenceEvent) {
        this.supp.fireSequenceEvent(sequenceEvent);
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
        this.supp.addSequenceListener(sequenceListener);
    }

    public void addVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        this.supp.addVetoableSequenceListener(vetoableSequenceListener);
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
        this.supp.removeSequenceListener(sequenceListener);
    }

    public void removeVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        this.supp.removeVetoableSequenceListener(vetoableSequenceListener);
    }

    public void vetoableChangeOccurred(VetoableSequenceEvent vetoableSequenceEvent) throws SequenceVetoException {
        this.fireVetoableSequenceEvent(vetoableSequenceEvent);
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        this.fireSequenceEvent(sequenceEvent);
        if (sequenceEvent.getType() == SequenceEventType.GAPINSERT && ((GappedSequence)sequenceEvent.getSource()).getGappedLength() + this.getInset(this.getSequenceIndex((GappedSequence)sequenceEvent.getSource())) > this.getLength()) {
            this.setLengthQuietly(((GappedSequence)sequenceEvent.getSource()).getGappedLength() + this.getInset(this.getSequenceIndex((GappedSequence)sequenceEvent.getSource())));
            this.fireAlignmentEvent(new AlignmentEvent(this, this.getSequenceIndex((GappedSequence)sequenceEvent.getSource()), AlignmentEventType.LENGTH_CHANGE));
        }
        if (sequenceEvent.getType() == SequenceEventType.GAPDELETE) {
            GappedSequence gappedSequence = (GappedSequence)sequenceEvent.getSource();
            try {
                this.ensureLengthDecrease();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireAlignmentEvent(new AlignmentEvent(this, this.getSequenceIndex(gappedSequence), AlignmentEventType.LENGTH_CHANGE));
        }
    }
}

