/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence;

import uk.ac.man.bioinf.sequence.DefaultSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.DefaultGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexElementFactory;
import uk.ac.man.bioinf.sequence.complex.ComplexSequence;
import uk.ac.man.bioinf.sequence.complex.GappedComplexSequence;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.identifier.Identifier;

public class Sequences {
    private Sequences() {
    }

    public static GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType) {
        return DefaultGappedSequence.getElementsAsGappedSequence(elementArray, sequenceType);
    }

    public static GappedSequence getElementsAsGappedSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        return DefaultGappedSequence.getElementsAsGappedSequence(elementArray, sequenceType, identifier);
    }

    public static Sequence getElementsAsSequence(Element[] elementArray, SequenceType sequenceType) {
        return new DefaultSequence(elementArray, sequenceType);
    }

    public static Sequence getElementsAsSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        return new DefaultSequence(elementArray, sequenceType, identifier);
    }

    public static int chompLeadingGaps(GappedSequence gappedSequence) throws SequenceVetoException {
        int n = 0;
        while (gappedSequence.getLength() > 1 && gappedSequence.getGappedElementAt(1) == Gap.GAP) {
            gappedSequence.deleteGapAt(1);
            ++n;
        }
        return n;
    }

    public static int chompTrailingGaps(GappedSequence gappedSequence) throws SequenceVetoException {
        int n = 0;
        while (gappedSequence.getGappedElementAt(gappedSequence.getGappedLength()) == Gap.GAP) {
            gappedSequence.deleteGapAt(gappedSequence.getGappedLength());
            ++n;
        }
        return n;
    }

    public static int getNumberGapsUpstreamFrom(int n, GappedSequence gappedSequence) {
        if (n < 1 || n > gappedSequence.getGappedLength()) {
            return 0;
        }
        int n2 = 0;
        while (n2 + n < gappedSequence.getGappedLength() && gappedSequence.getGappedElementAt(n2 + n) == Gap.gap) {
            ++n2;
        }
        return n2;
    }

    public static int getNumberGapsDownstreamFrom(int n, GappedSequence gappedSequence) {
        if (n < 1 || n > gappedSequence.getGappedLength()) {
            return 0;
        }
        int n2 = 0;
        while (n - n2 > 1 && gappedSequence.getGappedElementAt(n - n2) == Gap.gap) {
            ++n2;
        }
        return n2;
    }

    public static String getSequenceAsString(Sequence sequence) {
        return String.valueOf(sequence.getSequenceAsChars());
    }

    public static String getSubSequenceAsString(Sequence sequence, int n, int n2) {
        return Sequences.getSequenceAsString(sequence.getSubSequence(n, n2));
    }

    public static String getGappedSequenceAsString(GappedSequence gappedSequence) {
        return String.valueOf(gappedSequence.getGappedSequenceAsChars());
    }

    public static String getGappedSubSequenceAsString(GappedSequence gappedSequence, int n, int n2) {
        return Sequences.getGappedSequenceAsString(gappedSequence.getGappedSubSequence(n, n2));
    }

    public static String getElementsAsString(Element[] elementArray) {
        char[] cArray = new char[elementArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = elementArray[n].toChar();
            ++n;
        }
        return String.valueOf(cArray);
    }

    public static String getComplexSequenceAsString(ComplexSequence complexSequence) {
        return String.valueOf(complexSequence.getComplexSequenceAsChars());
    }

    public static ComplexElement[] getResiduesAsComplexElements(Residue[] residueArray) {
        ComplexElement[] complexElementArray = new ComplexElement[residueArray.length];
        int n = 0;
        while (n < residueArray.length) {
            complexElementArray[n] = ComplexElementFactory.getComplexElement(residueArray[n]);
            ++n;
        }
        return complexElementArray;
    }

    public static void printAlignment(SequenceAlignment sequenceAlignment) {
        System.out.print("Alignment Size: " + sequenceAlignment.getNumberSequences() + " Length: " + sequenceAlignment.getLength());
        System.out.println();
        int n = 1;
        while (n < sequenceAlignment.getNumberSequences() + 1) {
            GappedSequence gappedSequence = sequenceAlignment.getSequenceAt(n);
            System.out.println("Sequence " + n + ": " + gappedSequence.getIdentifier().getTitle() + " Length: " + gappedSequence.getGappedLength());
            int n2 = 0;
            while (n2 < sequenceAlignment.getInset(n)) {
                System.out.print("+");
                ++n2;
            }
            Sequences.printSequence(gappedSequence);
            ++n;
        }
    }

    public static void printSequence(GappedSequence gappedSequence) {
        System.out.println(Sequences.getGappedSequenceAsString(gappedSequence));
    }

    public static void printSequence(ComplexSequence complexSequence) {
        System.out.println(Sequences.getComplexSequenceAsString(complexSequence));
    }

    public static void printSequence(GappedComplexSequence gappedComplexSequence) {
        Sequences.printSequence((GappedSequence)gappedComplexSequence);
        Sequences.printSequence((ComplexSequence)gappedComplexSequence);
    }

    public static void printSequence(Sequence sequence) {
        System.out.println(Sequences.getSequenceAsString(sequence));
    }

    public static void printElements(Element[] elementArray) {
        System.out.println(Sequences.getElementsAsString(elementArray));
    }
}

