/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.man.bioinf.sequence.AbstractEditableSequence;
import uk.ac.man.bioinf.sequence.EditableSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;

public class DefaultEditableSequence
extends AbstractEditableSequence
implements EditableSequence {
    private ArrayList elements;
    private Identifier ident;

    public DefaultEditableSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        super(sequenceType);
        this.checkSequenceType(elementArray);
        this.ident = this.ident;
        this.elements = new ArrayList<Element>(Arrays.asList(elementArray));
    }

    public DefaultEditableSequence(Sequence sequence, SequenceType sequenceType) {
        this(sequence.getSequenceAsElements(), sequenceType, new NoIdentifier());
    }

    public DefaultEditableSequence(Sequence sequence) {
        this(sequence, sequence.getSequenceType());
    }

    public Identifier getIdentifier() {
        return this.ident;
    }

    public Element getElementAt(int n) {
        return (Element)this.elements.get(n - 1);
    }

    public int getLength() {
        return this.elements.size();
    }

    public Element[] getSequenceAsElements() {
        Object[] objectArray = this.elements.toArray();
        Element[] elementArray = new Element[objectArray.length];
        System.arraycopy(objectArray, 0, elementArray, 0, objectArray.length);
        return elementArray;
    }

    protected Element setElementAtQuietly(Element element, int n) {
        this.checkSequenceType(element);
        Element element2 = this.getElementAt(n);
        this.elements.set(n - 1, element);
        return element2;
    }

    protected void insertElementAtQuietly(Element element, int n) {
        this.checkSequenceType(element);
        this.elements.add(n - 1, element);
    }

    protected Element deleteElementAtQuietly(int n) {
        return (Element)this.elements.remove(n - 1);
    }
}

