/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io.parsers;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import uk.ac.man.bioinf.io.AlignmentOutputParser;
import uk.ac.man.bioinf.io.InvalidSequenceTypeParserException;
import uk.ac.man.bioinf.io.ParserExceptionHandler;
import uk.ac.man.bioinf.io.SequenceWriterException;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.types.ProteinSequenceType;

public class MotProteinParser
implements AlignmentOutputParser {
    public Writer write(SequenceAlignment sequenceAlignment, Writer writer, ParserExceptionHandler parserExceptionHandler) {
        try {
            if (sequenceAlignment.getSequenceType() != ProteinSequenceType.getInstance()) {
                throw new InvalidSequenceTypeParserException(ProteinSequenceType.getInstance());
            }
            writer.write("# Produced by Cinema " + DateFormat.getTimeInstance().format(new Date()) + "\n");
            Sequences.printAlignment(sequenceAlignment);
            int n = 1;
            while (n < sequenceAlignment.getNumberSequences() + 1) {
                GappedSequence gappedSequence = sequenceAlignment.getSequenceAt(n);
                Sequences.printSequence(gappedSequence);
                if (sequenceAlignment.getInset(n) != 0) {
                    throw new InvalidSequenceTypeException("Mot files can not contain any gaps");
                }
                String string = Sequences.getGappedSequenceAsString(gappedSequence);
                writer.write(string);
                writer.write("\n");
                ++n;
            }
        }
        catch (InvalidSequenceTypeParserException invalidSequenceTypeParserException) {
            parserExceptionHandler.handleException(invalidSequenceTypeParserException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            parserExceptionHandler.handleException(new SequenceWriterException());
        }
        return writer;
    }

    public String getDescription() {
        return "Parser for .mot file format.";
    }
}

