/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io.parsers;

import uk.ac.man.bioinf.io.ParserExceptionHandler;
import uk.ac.man.bioinf.io.SequenceInputParser;
import uk.ac.man.bioinf.io.UnknownElementException;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.types.AminoAcid;
import uk.ac.man.bioinf.sequence.types.ProteinSequenceType;

public abstract class AbstractProteinSequenceInputParser
implements SequenceInputParser {
    private static AminoAcid[] aa;

    protected Sequence toSequence(Identifier identifier, String string, ParserExceptionHandler parserExceptionHandler) {
        return Sequences.getElementsAsSequence(this.toElements(string, parserExceptionHandler), ProteinSequenceType.getInstance(), identifier);
    }

    protected Element[] toElements(String string, ParserExceptionHandler parserExceptionHandler) {
        Element[] elementArray = new Element[string.length()];
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n) - 65;
            if (n2 >= elementArray.length) {
                parserExceptionHandler.handleException(this.createException(n, (char)n2));
            }
            elementArray[n] = aa[string.charAt(n) - 65];
            if (elementArray[n] == null) {
                System.out.println("Element not recognised is " + string.charAt(n));
                parserExceptionHandler.handleException(this.createException(n, (char)n2));
            }
            ++n;
        }
        return elementArray;
    }

    protected UnknownElementException createException(int n, char c) {
        return new UnknownElementException("Element (" + c + ") at position " + (n + 1) + " was not recognised", n + 1);
    }

    static {
        AminoAcid[] aminoAcidArray = AminoAcid.getAll();
        aa = new AminoAcid[26];
        int n = 0;
        while (n < aminoAcidArray.length) {
            AbstractProteinSequenceInputParser.aa[aminoAcidArray[n].toChar() - 65] = aminoAcidArray[n];
            ++n;
        }
    }
}

