/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io.parsers;

import uk.ac.man.bioinf.io.AlignmentInputParser;
import uk.ac.man.bioinf.io.ParserExceptionHandler;
import uk.ac.man.bioinf.io.UnknownElementException;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.identifier.SimpleIdentifier;
import uk.ac.man.bioinf.sequence.types.AminoAcid;
import uk.ac.man.bioinf.sequence.types.ProteinSequenceType;

public abstract class AbstractProteinAlignmentInputParser
implements AlignmentInputParser {
    private static AminoAcid[] aa;

    protected GappedSequence toSequence(String string, String string2, ParserExceptionHandler parserExceptionHandler) {
        Element[] elementArray = new Element[string.length()];
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == Gap.GAP.toChar()) {
                elementArray[n] = Gap.GAP;
            } else {
                try {
                    elementArray[n] = aa[string.charAt(n) - 65];
                    if (elementArray[n] == null) {
                        parserExceptionHandler.handleException(new UnknownElementException("Element (" + string.charAt(n) + ") at position " + (n + 1) + " was not recognised", n + 1, string, new SimpleIdentifier(string2)));
                        elementArray[n] = Gap.GAP;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    parserExceptionHandler.handleException(new UnknownElementException("Element (" + string.charAt(n) + ") at position " + (n + 1) + " was not recognised", n + 1, string, new SimpleIdentifier(string2)));
                    elementArray[n] = Gap.GAP;
                }
            }
            ++n;
        }
        return Sequences.getElementsAsGappedSequence(elementArray, ProteinSequenceType.getInstance(), new SimpleIdentifier(string2));
    }

    static {
        AminoAcid[] aminoAcidArray = AminoAcid.getAll();
        aa = new AminoAcid[26];
        int n = 0;
        while (n < aminoAcidArray.length) {
            AbstractProteinAlignmentInputParser.aa[aminoAcidArray[n].toChar() - 65] = aminoAcidArray[n];
            ++n;
        }
    }
}

