/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.analysis.misc;

import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.AlignmentColumn;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.util.ChangeableListenerSupport;

public class PercentageIDCalculator
implements AlignmentListener,
SequenceListener {
    private AlignmentColumn col = new AlignmentColumn();
    private double[] variance;
    private Element[] consensus;
    private SequenceAlignment alignment;
    private ChangeableListenerSupport supp = new ChangeableListenerSupport();
    private boolean invalid = true;
    private int checksum = 0;

    public PercentageIDCalculator(SequenceAlignment sequenceAlignment) {
        this.alignment = sequenceAlignment;
        sequenceAlignment.addAlignmentListener(this);
        sequenceAlignment.addSequenceListener(this);
    }

    private synchronized void calculate() {
        SequenceType sequenceType = this.alignment.getSequenceType();
        this.consensus = new Element[this.alignment.getLength()];
        this.variance = new double[this.alignment.getLength()];
        int[] nArray = new int[sequenceType.size()];
        this.col.setAlignment(this.alignment);
        int n = this.alignment.getLength() + 1;
        int n2 = this.alignment.getNumberSequences() + 1;
        int n3 = 1;
        while (n3 < n) {
            int n4 = 0;
            this.col.setColumn(n3);
            int n5 = 1;
            while (n5 < n2) {
                Element element = this.col.getElementAtRow(n5);
                if (element != Gap.GAP) {
                    int n6 = sequenceType.getIntForElement(element);
                    nArray[n6] = nArray[n6] + 1;
                } else {
                    ++n4;
                }
                ++n5;
            }
            int n7 = 0;
            int n8 = 0;
            while (n8 < nArray.length) {
                if (nArray[n8] > n7) {
                    n7 = nArray[n8];
                    this.consensus[n3 - 1] = sequenceType.getElementForInt(n8);
                }
                nArray[n8] = 0;
                if (n4 > n7) {
                    this.consensus[n3 - 1] = Gap.GAP;
                }
                ++n8;
            }
            if (n2 != 1) {
                this.variance[n3 - 1] = (double)n7 / (double)(n2 - 1);
            }
            ++n3;
        }
        this.invalid = false;
    }

    private void invalidate() {
        ++this.checksum;
        this.invalid = true;
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        this.invalidate();
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        this.invalidate();
    }

    public synchronized int getCheckSum() {
        return this.checksum;
    }

    public synchronized double[] getVariance() {
        if (this.invalid) {
            this.calculate();
        }
        return this.variance;
    }

    public synchronized Element[] getConsensus() {
        if (this.invalid) {
            this.calculate();
        }
        return this.consensus;
    }

    public SequenceAlignment getAlignment() {
        return this.alignment;
    }
}

