/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.analysis.consensus;

import uk.ac.man.bioinf.analysis.consensus.ConsensusCalculator;
import uk.ac.man.bioinf.analysis.consensus.ConsensusIdentifier;
import uk.ac.man.bioinf.analysis.misc.PercentageIDCalculator;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;

public class PercentageIDConsensus
implements ConsensusCalculator {
    public static final String NAME = "Percentage ID Consensus Calculator";
    private PercentageIDCalculator calc;
    private GappedSequence sequence;
    private int checksum = -1;

    public PercentageIDConsensus(PercentageIDCalculator percentageIDCalculator) {
        this.calc = percentageIDCalculator;
    }

    private void fetchConsensus() {
        this.sequence = Sequences.getElementsAsGappedSequence(this.calc.getConsensus(), this.calc.getAlignment().getSequenceType(), new ConsensusIdentifier(this.calc.getAlignment()));
        this.checksum = this.calc.getCheckSum();
    }

    public GappedSequence getCurrentConsensus() {
        if (this.checksum != this.calc.getCheckSum()) {
            this.fetchConsensus();
        }
        return this.sequence;
    }

    public String getCalculatorName() {
        return NAME;
    }

    public SequenceAlignment getSequenceAlignment() {
        return this.calc.getAlignment();
    }
}

