/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.IntStack;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.XPath;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    private XPath.LocationPath[] fLocationPaths;
    private boolean fShouldBufferContent;
    private boolean fBufferContent;
    private StringBuffer fMatchedBuffer = new StringBuffer();
    private boolean[] fMatched;
    private String fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    protected StringPool fStringPool;
    protected NamespacesScope fNamespacesScope;
    protected IdentityConstraint fIDConstraint;

    public XPathMatcher(XPath xPath) {
        this(xPath, false, null);
    }

    public XPathMatcher(XPath xPath, boolean bl, IdentityConstraint identityConstraint) {
        this.fLocationPaths = xPath.getLocationPaths();
        this.fShouldBufferContent = bl;
        this.fIDConstraint = identityConstraint;
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        int n = 0;
        while (n < this.fStepIndexes.length) {
            this.fStepIndexes[n] = new IntStack();
            ++n;
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new boolean[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            if (this.fMatched[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean getIsSelector() {
        return this.fIDConstraint == null;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIDConstraint;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void matched(String string, DatatypeValidator datatypeValidator, boolean bl) throws Exception {
    }

    public void startDocumentFragment(StringPool stringPool) throws Exception {
        this.clear();
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fStepIndexes[n].clear();
            this.fCurrentStep[n] = 0;
            this.fNoMatchDepth[n] = 0;
            this.fMatched[n] = false;
            ++n;
        }
        this.fStringPool = stringPool;
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(QName var1_1, XMLAttrList var2_2, int var3_3, int var4_4, SchemaGrammar var5_5) throws Exception {
        var6_6 = 0;
        while (var6_6 < this.fLocationPaths.length) {
            block22: {
                block24: {
                    block23: {
                        block21: {
                            var7_7 = this.fCurrentStep[var6_6];
                            this.fStepIndexes[var6_6].push(var7_7);
                            if (!this.fMatched[var6_6] && this.fNoMatchDepth[var6_6] <= 0) break block21;
                            v0 = var6_6;
                            this.fNoMatchDepth[v0] = this.fNoMatchDepth[v0] + 1;
                            break block22;
                        }
                        var8_8 = this.fLocationPaths[var6_6].steps;
                        while (this.fCurrentStep[var6_6] < var8_8.length && var8_8[this.fCurrentStep[var6_6]].axis.type == 3) {
                            v1 = var6_6;
                            this.fCurrentStep[v1] = this.fCurrentStep[v1] + 1;
                        }
                        if (this.fCurrentStep[var6_6] != var8_8.length) break block23;
                        this.fMatched[var6_6] = true;
                        var9_9 = 0;
                        while (var9_9 < var6_6 && !this.fMatched[var9_9]) {
                            ++var9_9;
                        }
                        if (var9_9 == var6_6) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                        break block22;
                    }
                    var9_9 = this.fCurrentStep[var6_6];
                    while (this.fCurrentStep[var6_6] < var8_8.length && var8_8[this.fCurrentStep[var6_6]].axis.type == 4) {
                        v2 = var6_6;
                        this.fCurrentStep[v2] = this.fCurrentStep[v2] + 1;
                    }
                    if (this.fCurrentStep[var6_6] != var8_8.length) break block24;
                    v3 = var6_6;
                    this.fNoMatchDepth[v3] = this.fNoMatchDepth[v3] + 1;
                    break block22;
                }
                if (this.fCurrentStep[var6_6] != var7_7 && this.fCurrentStep[var6_6] <= var9_9 || var8_8[this.fCurrentStep[var6_6]].axis.type != 1) ** GOTO lbl47
                var10_10 = var8_8[this.fCurrentStep[var6_6]];
                var11_13 = var10_10.nodeTest;
                if (var11_13.type == 1 && !var11_13.name.equals(var1_1)) {
                    if (this.fCurrentStep[var6_6] > var9_9) {
                        this.fCurrentStep[var6_6] = var9_9;
                    } else {
                        v4 = var6_6;
                        this.fNoMatchDepth[v4] = this.fNoMatchDepth[v4] + 1;
                    }
                } else {
                    v5 = var6_6;
                    this.fCurrentStep[v5] = this.fCurrentStep[v5] + 1;
lbl47:
                    // 2 sources

                    if (this.fCurrentStep[var6_6] == var8_8.length) {
                        this.fMatched[var6_6] = true;
                        var10_11 = 0;
                        while (var10_11 < var6_6 && !this.fMatched[var10_11]) {
                            ++var10_11;
                        }
                        if (var10_11 == var6_6) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                    } else if (this.fCurrentStep[var6_6] < var8_8.length && var8_8[this.fCurrentStep[var6_6]].axis.type == 2) {
                        var10_12 = var2_2.getFirstAttr(var3_3);
                        if (var10_12 != -1) {
                            var11_13 = var8_8[this.fCurrentStep[var6_6]].nodeTest;
                            var12_14 = new QName();
                            while (var10_12 != -1) {
                                var13_15 = var2_2.getAttrPrefix(var10_12);
                                var14_16 = var2_2.getAttrLocalpart(var10_12);
                                var15_17 = var2_2.getAttrName(var10_12);
                                var16_18 = var2_2.getAttrURI(var10_12);
                                var12_14.setValues(var13_15, var14_16, var15_17, var16_18);
                                if (var11_13.type != 1 || var11_13.name.equals(var12_14)) {
                                    v6 = var6_6;
                                    this.fCurrentStep[v6] = this.fCurrentStep[v6] + 1;
                                    if (this.fCurrentStep[var6_6] != var8_8.length) break;
                                    this.fMatched[var6_6] = true;
                                    var17_19 = 0;
                                    while (var17_19 < var6_6 && !this.fMatched[var17_19]) {
                                        ++var17_19;
                                    }
                                    if (var17_19 != var6_6) break;
                                    var18_20 = var2_2.getAttValue(var10_12);
                                    this.fMatchedString = this.fStringPool.toString(var18_20);
                                    var19_21 = var5_5.getAttributeDeclIndex(var4_4, var12_14);
                                    var20_22 = new XMLAttributeDecl();
                                    var5_5.getAttributeDecl(var19_21, var20_22);
                                    var21_23 = var20_22.datatypeValidator;
                                    this.matched(this.fMatchedString, var21_23, false);
                                    break;
                                }
                                var10_12 = var2_2.getNextAttr(var10_12);
                            }
                        }
                        if (!this.fMatched[var6_6]) {
                            if (this.fCurrentStep[var6_6] > var9_9) {
                                this.fCurrentStep[var6_6] = var9_9;
                            } else {
                                v7 = var6_6;
                                this.fNoMatchDepth[v7] = this.fNoMatchDepth[v7] + 1;
                            }
                        }
                    }
                }
            }
            ++var6_6;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        int n3 = 0;
        while (n3 < this.fLocationPaths.length) {
            if (this.fBufferContent && this.fNoMatchDepth[n3] == 0) {
                this.fMatchedBuffer.append(cArray, n, n2);
                break;
            }
            ++n3;
        }
    }

    public void endElement(QName qName, int n, SchemaGrammar schemaGrammar) throws Exception {
        int n2 = 0;
        while (n2 < this.fLocationPaths.length) {
            block10: {
                block9: {
                    block8: {
                        if (this.fNoMatchDepth[n2] <= 0) break block8;
                        int n3 = n2;
                        this.fNoMatchDepth[n3] = this.fNoMatchDepth[n3] - 1;
                        break block9;
                    }
                    int n4 = 0;
                    while (n4 < n2 && !this.fMatched[n4]) {
                        ++n4;
                    }
                    if (n4 < n2) break block10;
                    if (this.fBufferContent) {
                        this.fBufferContent = false;
                        this.fMatchedString = this.fMatchedBuffer.toString();
                        XMLElementDecl xMLElementDecl = new XMLElementDecl();
                        schemaGrammar.getElementDecl(n, xMLElementDecl);
                        DatatypeValidator datatypeValidator = xMLElementDecl.datatypeValidator;
                        if (xMLElementDecl != null) {
                            this.matched(this.fMatchedString, datatypeValidator, (schemaGrammar.getElementDeclMiscFlags(n) & 1) != 0);
                        } else {
                            this.matched(this.fMatchedString, null, false);
                        }
                    }
                    this.clear();
                }
                this.fCurrentStep[n2] = this.fStepIndexes[n2].pop();
            }
            ++n2;
        }
    }

    public void endDocumentFragment() throws Exception {
        this.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < this.fLocationPaths.length) {
            stringBuffer.append('[');
            XPath.Step[] stepArray = this.fLocationPaths[n2].steps;
            int n3 = 0;
            while (n3 < stepArray.length) {
                if (n3 == this.fCurrentStep[n2]) {
                    stringBuffer.append('^');
                }
                stringBuffer.append(stepArray[n2].toString());
                if (n3 < stepArray.length - 1) {
                    stringBuffer.append('/');
                }
                ++n3;
            }
            if (this.fCurrentStep[n2] == stepArray.length) {
                stringBuffer.append('^');
            }
            stringBuffer.append(']');
            stringBuffer.append(',');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void clear() {
        this.fBufferContent = false;
        this.fMatchedBuffer.setLength(0);
        this.fMatchedString = null;
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fMatched[n] = false;
            ++n;
        }
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

