/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public class DurationDatatypeValidator
extends DateTimeValidator {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};
    private int[][] fDuration = null;

    public DurationDatatypeValidator() throws InvalidDatatypeFacetException {
    }

    public DurationDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        int n;
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        char c = this.fBuffer.charAt(this.fStart++);
        if (c != 'P' && c != '-') {
            throw new SchemaDateTimeException();
        }
        int n2 = nArray[7] = c == '-' ? 45 : 0;
        if (c == '-' && this.fBuffer.charAt(this.fStart++) != 'P') {
            throw new SchemaDateTimeException();
        }
        int n3 = 1;
        if (nArray[7] == 45) {
            n3 = -1;
        }
        boolean bl = false;
        int n4 = this.indexOf(this.fStart, this.fEnd, 'T');
        if (n4 == -1) {
            n4 = this.fEnd;
        }
        if ((n = this.indexOf(this.fStart, n4, 'Y')) != -1) {
            nArray[0] = n3 * this.parseInt(this.fStart, n);
            this.fStart = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(this.fStart, n4, 'M')) != -1) {
            nArray[1] = n3 * this.parseInt(this.fStart, n);
            this.fStart = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(this.fStart, n4, 'D')) != -1) {
            nArray[2] = n3 * this.parseInt(this.fStart, n);
            this.fStart = n + 1;
            bl = true;
        }
        if (this.fEnd == n4 && this.fStart != this.fEnd) {
            throw new SchemaDateTimeException();
        }
        if (this.fEnd != n4) {
            if ((n = this.indexOf(++this.fStart, this.fEnd, 'H')) != -1) {
                nArray[3] = n3 * this.parseInt(this.fStart, n);
                this.fStart = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(this.fStart, this.fEnd, 'M')) != -1) {
                nArray[4] = n3 * this.parseInt(this.fStart, n);
                this.fStart = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(this.fStart, this.fEnd, 'S')) != -1) {
                int n5 = this.indexOf(this.fStart, n, '.');
                if (n5 > 0) {
                    nArray[5] = n3 * this.parseInt(this.fStart, n5);
                    nArray[6] = n3 * this.parseInt(n5 + 1, n);
                } else {
                    nArray[5] = n3 * this.parseInt(this.fStart, n);
                }
                this.fStart = n + 1;
                bl = true;
            }
            if (this.fStart != this.fEnd || this.fBuffer.charAt(--this.fStart) == 'T') {
                throw new SchemaDateTimeException();
            }
        }
        if (!bl) {
            throw new SchemaDateTimeException();
        }
        return nArray;
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        int[] nArray4;
        short s = 2;
        short s2 = this.compareOrder(nArray, nArray2);
        if (s2 == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][8];
        }
        if ((s2 = this.compareOrder(nArray4 = this.addDuration(nArray, 0, this.fDuration[0]), nArray3 = this.addDuration(nArray2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 1, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 1, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 2, this.fDuration[0]);
        s = this.compareOrder(nArray4, nArray3 = this.addDuration(nArray2, 2, this.fDuration[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray4 = this.addDuration(nArray, 3, this.fDuration[0]);
        nArray3 = this.addDuration(nArray2, 3, this.fDuration[1]);
        s = this.compareOrder(nArray4, nArray3);
        s2 = this.compareResults(s2, s, bl);
        return s2;
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 2;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }

    private int[] addDuration(int[] nArray, int n, int[] nArray2) {
        this.resetDateObj(nArray2);
        int n2 = DATETIMES[n][1] + nArray[1];
        nArray2[1] = this.modulo(n2, 1, 13);
        int n3 = this.fQuotient(n2, 1, 13);
        nArray2[0] = DATETIMES[n][0] + nArray[0] + n3;
        n2 = DATETIMES[n][5] + nArray[5];
        n3 = this.fQuotient(n2, 60);
        nArray2[5] = this.mod(n2, 60, n3);
        n2 = DATETIMES[n][4] + nArray[4] + n3;
        n3 = this.fQuotient(n2, 60);
        nArray2[4] = this.mod(n2, 60, n3);
        n2 = DATETIMES[n][3] + nArray[3] + n3;
        n3 = this.fQuotient(n2, 24);
        nArray2[3] = this.mod(n2, 24, n3);
        nArray2[2] = DATETIMES[n][2] + nArray[2] + n3;
        while (true) {
            n2 = this.maxDayInMonthFor(nArray2[0], nArray2[1]);
            if (nArray2[2] < 1) {
                nArray2[2] = nArray2[2] + this.maxDayInMonthFor(nArray2[0], nArray2[1] - 1);
                n3 = -1;
            } else {
                if (nArray2[2] <= n2) break;
                nArray2[2] = nArray2[2] - n2;
                n3 = 1;
            }
            n2 = nArray2[1] + n3;
            nArray2[1] = this.modulo(n2, 1, 13);
            nArray2[0] = nArray2[0] + this.fQuotient(n2, 1, 13);
        }
        nArray2[7] = 90;
        return nArray2;
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        int n = 1;
        if (nArray[0] < 0) {
            this.message.append('-');
            n = -1;
        }
        this.message.append('P');
        this.message.append(n * nArray[0]);
        this.message.append('Y');
        this.message.append(n * nArray[1]);
        this.message.append('M');
        this.message.append(n * nArray[2]);
        this.message.append('D');
        this.message.append('T');
        this.message.append(n * nArray[3]);
        this.message.append('H');
        this.message.append(n * nArray[4]);
        this.message.append('M');
        this.message.append(n * nArray[5]);
        this.message.append('.');
        this.message.append(n * nArray[6]);
        this.message.append('S');
        return this.message.toString();
    }
}

