/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;

public class CMAny
extends CMNode {
    private int fType;
    private int fURI;
    private int fPosition = -1;

    public CMAny(int n, int n2, int n3) throws CMException {
        super(n);
        this.fType = n;
        this.fURI = n2;
        this.fPosition = n3;
    }

    final int getType() {
        return this.fType;
    }

    final int getURI() {
        return this.fURI;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    boolean isNullable() throws CMException {
        return this.fPosition == -1;
    }

    String toString(StringPool stringPool) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        switch (this.fType & 0xF) {
            case 6: {
                stringBuffer.append("##any");
                break;
            }
            case 8: {
                stringBuffer.append("##any:uri=" + stringPool.toString(this.fURI));
                break;
            }
            case 7: {
                stringBuffer.append("##other:uri=" + stringPool.toString(this.fURI));
            }
        }
        stringBuffer.append(stringPool.toString(this.fURI));
        stringBuffer.append(')');
        if (this.fPosition >= 0) {
            stringBuffer.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return stringBuffer.toString();
    }

    protected void calcFirstPos(CMStateSet cMStateSet) throws CMException {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet cMStateSet) throws CMException {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }
}

