/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.apps.optionable;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.man.bioinf.apps.optionable.OptionHandler;
import uk.ac.man.bioinf.apps.optionable.Optionable;
import uk.ac.man.bioinf.apps.optionable.OptionableExceptionHandler;
import uk.ac.man.bioinf.apps.optionable.OptionableSourceNotFoundException;
import uk.ac.man.bioinf.apps.systemevents.SystemEvent;
import uk.ac.man.bioinf.apps.systemevents.SystemEventOption;
import uk.ac.man.bioinf.apps.systemevents.SystemEventProducer;
import uk.ac.man.bioinf.apps.systemevents.SystemListener;

public abstract class SaveableOptions
implements SystemListener,
OptionHandler {
    private Hashtable options = new Hashtable();
    private Vector optionObjects = new Vector();
    private OptionableExceptionHandler exHandler;
    static /* synthetic */ Class class$uk$ac$man$bioinf$apps$optionable$FileSaveableOptions;

    public SaveableOptions(SystemEventProducer systemEventProducer, OptionableExceptionHandler optionableExceptionHandler) {
        this.exHandler = optionableExceptionHandler;
        systemEventProducer.addSystemEventListener(this);
    }

    protected OptionableExceptionHandler getExceptionHandler() {
        return this.exHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemEventOccured(SystemEvent systemEvent) {
        if (systemEvent.getOption() == SystemEventOption.SYSTEM_SHUTDOWN) {
            Class clazz = class$uk$ac$man$bioinf$apps$optionable$FileSaveableOptions == null ? (class$uk$ac$man$bioinf$apps$optionable$FileSaveableOptions = SaveableOptions.class$("uk.ac.man.bioinf.apps.optionable.FileSaveableOptions")) : class$uk$ac$man$bioinf$apps$optionable$FileSaveableOptions;
            synchronized (clazz) {
                Enumeration enumeration = this.optionObjects.elements();
                while (enumeration.hasMoreElements()) {
                    Optionable optionable = (Optionable)enumeration.nextElement();
                    if (optionable.getOptionGroupName() == null) {
                        throw new RuntimeException("The group name of an optionable option should not be null");
                    }
                    if (optionable.getOptions() == null) continue;
                    this.options.put(optionable.getOptionGroupName(), optionable.getOptions());
                }
                this.saveOptions();
            }
        }
    }

    public int systemListenerPriority() {
        return 0;
    }

    public abstract OutputStream getSaveStream() throws IOException;

    public abstract InputStream getLoadStream() throws IOException;

    private void saveOptions() {
        block4: {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.getSaveStream());
                objectOutputStream.writeObject(this.options);
            }
            catch (IOException iOException) {
                if (this.exHandler.handleSaveException(iOException)) {
                    this.saveOptions();
                }
            }
            catch (Exception exception) {
                if (!this.exHandler.handleSaveException(exception)) break block4;
                this.saveOptions();
            }
        }
    }

    protected void loadOptions() {
        block10: {
            try {
                if (this.getLoadStream() != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.getLoadStream());
                    this.options = (Hashtable)objectInputStream.readObject();
                } else {
                    this.options = new Hashtable();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.exHandler.handleLoadException(classNotFoundException)) {
                    this.loadOptions();
                }
            }
            catch (OptionableSourceNotFoundException optionableSourceNotFoundException) {
                if (this.exHandler.handleLoadException(optionableSourceNotFoundException)) {
                    this.loadOptions();
                }
            }
            catch (IOException iOException) {
                if (this.exHandler.handleLoadException(iOException)) {
                    this.loadOptions();
                }
            }
            catch (Exception exception) {
                if (!this.exHandler.handleLoadException(exception)) break block10;
                this.loadOptions();
            }
        }
    }

    public synchronized void addOptionable(Optionable optionable) {
        this.optionObjects.add(optionable);
        optionable.setOptionHandler(this);
        this.requestOptionUpdate(optionable);
    }

    public synchronized void removeOptionable(Optionable optionable) {
        this.optionObjects.remove(optionable);
    }

    public synchronized void requestOptionUpdate(Optionable optionable) {
        optionable.setOptions(this.options.get(optionable.getOptionGroupName()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

