/*
 *This library is free software; you can redistribute it and/or
 *modify it under the terms of the GNU Lesser General Public
 *License as published by the Free Software Foundation; either
 *version 2.1 of the License, or (at your option) any later version.
 *
 *This library is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *Lesser General Public License for more details.
 *
 *You should have received a copy of the GNU Lesser General Public
 *License along with this library; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
 * This software was written by Phillip Lord (p.lord@hgmp.mrc.ac.uk)
 * whilst at the University of Manchester as a Pfizer post-doctoral 
 * Research Fellow. 
 *
 * The initial code base is copyright by Pfizer, or the University
 * of Manchester. Modifications to the initial code base are copyright
 * of their respective authors, or their employers as appropriate. 
 * Authorship of the modifications may be determined from the ChangeLog
 * placed at the end of this file
 */

package uk.ac.man.bioinf.sequence.complex; // Package name inserted by JPack


/**
 * ModificationSetFactory.java
 *
 *
 * Created: Tue Feb 29 20:18:04 2000
 *
 * @author Phillip Lord
 * @version $Id: ModificationSetFactory.java,v 1.5 2001/04/11 17:04:43 lord Exp $
 */

class ModificationSetFactory 
{
  private static ModificationSetFactoryInterface fact = new WeakModificationSetFactory();
  
  
  static ModificationSet getModificationSet()
  {
    return fact.getModificationSet();
  }
  
  static ModificationSet getModificationSet( Modification modification )
  {
    return fact.getModificationSet( modification );
  }
  
  static ModificationSet getModificationSet( Modification[] modifications )
  {
    return fact.getModificationSet( modifications );
  }
  
  static ModificationSet getModificationSet( Modification[] modifications, Modification modification )
  {
    return fact.getModificationSet( modifications, modification );
  }
} // ModificationSetFactory



/*
 * ChangeLog
 * $Log: ModificationSetFactory.java,v $
 * Revision 1.5  2001/04/11 17:04:43  lord
 * Added License agreements to all code
 *
 * Revision 1.4  2000/11/27 18:14:02  lord
 * Realised that I had not implemented the ComplexSequence. Have now done
 * this and have made quite a few changes to this package as a result
 *
 * Revision 1.3  2000/05/30 16:04:18  lord
 * Have rationalised and sorted all the import statements
 *
 * Revision 1.2  2000/03/01 20:17:55  lord
 * Lots of changes
 *
 * Revision 1.1  2000/03/01 14:33:08  lord
 * Initial checkin
 *
 */
