/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceAdapter {
    protected Locale defaultLocale = Locale.getDefault();
    protected ResourceBundle bundle;
    protected String props;

    public ResourceAdapter() {
    }

    public ResourceAdapter(String string) throws IOException {
        this.props = string;
        this.init();
    }

    protected void init() throws IOException {
        this.bundle = ResourceBundle.getBundle(this.props, this.defaultLocale);
        if (this.bundle == null) {
            throw new IOException("Can't find properties file for resource bundle.");
        }
    }

    public String getMessageString(String string) {
        String string2 = this.bundle.getString("message." + string);
        return string2;
    }

    public String getToolTip(String string) {
        String string2 = this.bundle.getString("tooltip." + string);
        return string2;
    }

    public URL getHelpURL(String string) {
        String string2 = this.bundle.getString("helpURL." + string);
        URL uRL = this.getClass().getResource(string2);
        return uRL;
    }

    public URL getImageURL(String string) {
        String string2 = this.bundle.getString("image." + string);
        URL uRL = this.getClass().getResource(string2);
        return uRL;
    }

    public File getFile(String string) {
        String string2 = this.bundle.getString("file." + string);
        File file = new File(string2);
        return file;
    }

    public URL getURL(String string) {
        String string2 = this.bundle.getString("url." + string);
        URL uRL = this.getClass().getResource(string2);
        return uRL;
    }

    public String getTextString(String string) {
        String string2 = this.bundle.getString("string." + string);
        return string2;
    }
}

