/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.util;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntArrayList {
    private int size;
    private int[] elements;

    private IntArrayList(boolean bl) {
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int n) {
        this.elements = new int[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.elements.length;
        if (n > n2) {
            int[] nArray = this.elements;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elements = new int[n3];
            System.arraycopy(nArray, 0, this.elements, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            if (n == this.elements[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        int n2 = this.size - 1;
        while (n2 >= 0) {
            if (n == this.elements[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private void checkRange(int n) {
        if (n < 0 || n > this.size) {
            throw new NoSuchElementException("Attempt to access element " + n + " which doesnt exist");
        }
    }

    public int get(int n) {
        this.checkRange(n);
        return this.elements[n];
    }

    public int set(int n, int n2) {
        this.checkRange(n);
        int n3 = this.elements[n];
        this.elements[n] = n2;
        return n3;
    }

    public void add(int n) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = n;
    }

    public void add(int n, int n2) {
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = n2;
        ++this.size;
    }

    public int remove(int n) {
        this.checkRange(n);
        int n2 = this.elements[n];
        int n3 = this.size - 1 - n;
        if (n3 > 0) {
            System.arraycopy(this.elements, n + 1, this.elements, n, this.size - 1 - n);
        }
        --this.size;
        return n2;
    }

    public int[] remove(int n, int n2) {
        int n3 = n + n2;
        this.checkRange(n);
        this.checkRange(n3);
        int[] nArray = new int[n2];
        System.arraycopy(this.elements, n3, nArray, 0, n2);
        System.arraycopy(this.elements, n3, this.elements, n, n2);
        return nArray;
    }

    public void clear() {
        this.size = 0;
    }

    public IntArrayList getSubList(int n, int n2) {
        this.checkRange(n);
        this.checkRange(n + n2);
        IntArrayList intArrayList = new IntArrayList(true);
        intArrayList.elements = new int[n2];
        intArrayList.size = n2;
        System.arraycopy(this.elements, n, intArrayList.elements, 0, n2);
        return intArrayList;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.elements, 0, nArray, 0, this.size);
        return nArray;
    }

    public void sort() {
        Arrays.sort(this.elements, 0, this.size - 1);
    }

    public int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.elements[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public int linearSearch(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            if (this.elements[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean equals(IntArrayList intArrayList) {
        if (this.size != intArrayList.size) {
            return false;
        }
        int n = 0;
        while (n < this.size) {
            if (this.elements[n] != intArrayList.elements[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void print() {
        System.out.println("Index\tValue");
        int n = 0;
        while (n < this.size) {
            System.out.println(n + "\t" + this.elements[n]);
            ++n;
        }
    }
}

