/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.apps.systemevents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import uk.ac.man.bioinf.apps.systemevents.SystemEvent;
import uk.ac.man.bioinf.apps.systemevents.SystemEventOption;
import uk.ac.man.bioinf.apps.systemevents.SystemEventProducer;
import uk.ac.man.bioinf.apps.systemevents.SystemListener;
import uk.ac.man.bioinf.apps.systemevents.SystemVetoException;

public class SystemEventSupport
implements SystemEventProducer {
    private ArrayList list = new ArrayList();
    private int lastCalledPriority = Integer.MIN_VALUE;

    public void addSystemEventListener(SystemListener systemListener) {
        this.list.add(new ListenerToComparable(systemListener));
    }

    public void removeSystemEventListener(SystemListener systemListener) {
        this.list.remove(new ListenerToComparable(systemListener));
    }

    public void fireSystemEvent(SystemEventOption systemEventOption) throws SystemVetoException {
        this.lastCalledPriority = Integer.MIN_VALUE;
        Collections.sort(this.list);
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            SystemListener systemListener = ((ListenerToComparable)iterator.next()).getSystemListener();
            this.lastCalledPriority = systemListener.systemListenerPriority();
            systemListener.systemEventOccured(new SystemEvent(this, systemEventOption));
        }
    }

    public int getLastPriorityRun() {
        return this.lastCalledPriority;
    }

    private class ListenerToComparable
    implements Comparable {
        private SystemListener listener;

        public ListenerToComparable(SystemListener systemListener) {
            this.listener = systemListener;
        }

        public int compareTo(Object object) {
            ListenerToComparable listenerToComparable = (ListenerToComparable)object;
            return this.listener.systemListenerPriority() < listenerToComparable.systemListenerPriority() ? -1 : (this.listener.systemListenerPriority() == listenerToComparable.systemListenerPriority() ? 0 : 1);
        }

        public int systemListenerPriority() {
            return this.listener.systemListenerPriority();
        }

        public SystemListener getSystemListener() {
            return this.listener;
        }

        public boolean equals(Object object) {
            if (object instanceof ListenerToComparable) {
                return this.listener.equals(((ListenerToComparable)object).listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

