/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.schema.OneAttr;
import org.apache.xerces.validators.schema.OneElement;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GeneralAttrCheck {
    public static int ELE_CONTEXT_GLOBAL = 0;
    public static int ELE_CONTEXT_LOCAL = 1;
    public static int ATT_REQUIRED = 0;
    public static int ATT_OPT_DFLT = 1;
    public static int ATT_OPT_NODFLT = 2;
    protected static String PRE_GLOBAL = "G_";
    protected static String PRE_LOC_NAME = "LN_";
    protected static String PRE_LOC_REF = "LR_";
    protected static Hashtable fEleAttrsMap = new Hashtable();
    protected static DatatypeValidator[] fExtraDVs = null;
    protected static int dtCount = 0;
    protected static final int DT_ANYURI = dtCount++;
    protected static final int DT_BOOLEAN = dtCount++;
    protected static final int DT_ID = dtCount++;
    protected static final int DT_NONNEGINT = dtCount++;
    protected static final int DT_QNAME = dtCount++;
    protected static final int DT_STRING = dtCount++;
    protected static final int DT_TOKEN = dtCount++;
    protected static final int DT_NCNAME = dtCount++;
    protected static final int DT_XPATH = dtCount++;
    protected static final int DT_XPATH1 = dtCount++;
    protected static final int DT_BLOCK = -1;
    protected static final int DT_BLOCK1 = -2;
    protected static final int DT_FINAL = -3;
    protected static final int DT_FINAL1 = -4;
    protected static final int DT_FORM = -5;
    protected static final int DT_MAXOCCURS = -6;
    protected static final int DT_MAXOCCURS1 = -7;
    protected static final int DT_MEMBERTYPES = -8;
    protected static final int DT_MINOCCURS1 = -9;
    protected static final int DT_NAMESPACE = -10;
    protected static final int DT_PROCESSCONTENTS = -11;
    protected static final int DT_PUBLIC = -12;
    protected static final int DT_USE = -13;
    protected static final int DT_WHITESPACE = -14;
    private Hashtable fIdDefs = new Hashtable();
    protected XMLErrorReporter fErrorReporter = null;
    protected DatatypeValidatorFactoryImpl fDatatypeRegistry;
    protected Hashtable fProcessedElements = new Hashtable();
    protected Hashtable fNonSchemaAttrs = new Hashtable();

    private GeneralAttrCheck() {
    }

    public GeneralAttrCheck(XMLErrorReporter xMLErrorReporter, DatatypeValidatorFactoryImpl datatypeValidatorFactoryImpl) {
        this.fErrorReporter = xMLErrorReporter;
        this.fDatatypeRegistry = this.fDatatypeRegistry;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (fExtraDVs[DT_ANYURI] == null) {
                datatypeValidatorFactoryImpl.expandRegistryToFullSchemaSet();
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_ANYURI] = datatypeValidatorFactoryImpl.getDatatypeValidator("anyURI");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_BOOLEAN] = datatypeValidatorFactoryImpl.getDatatypeValidator("boolean");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_ID] = datatypeValidatorFactoryImpl.getDatatypeValidator("ID");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_NONNEGINT] = datatypeValidatorFactoryImpl.getDatatypeValidator("nonNegativeInteger");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_QNAME] = datatypeValidatorFactoryImpl.getDatatypeValidator("QName");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_STRING] = datatypeValidatorFactoryImpl.getDatatypeValidator("string");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_TOKEN] = datatypeValidatorFactoryImpl.getDatatypeValidator("token");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_NCNAME] = datatypeValidatorFactoryImpl.getDatatypeValidator("NCName");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_XPATH] = fExtraDVs[DT_STRING];
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_XPATH] = fExtraDVs[DT_STRING];
            }
        }
    }

    public Hashtable checkAttributes(Element element, int n) throws Exception {
        Object object;
        Object object2;
        if (element == null) {
            return null;
        }
        Hashtable<Object, Object[]> hashtable = (Hashtable<Object, Object[]>)this.fProcessedElements.get(element);
        if (hashtable != null) {
            return hashtable;
        }
        String string = element.getLocalName();
        String string2 = n == ELE_CONTEXT_GLOBAL ? PRE_GLOBAL + string : (element.getAttributeNode("ref") == null ? PRE_LOC_NAME + string : PRE_LOC_REF + string);
        OneElement oneElement = (OneElement)fEleAttrsMap.get(string2);
        if (oneElement == null) {
            this.reportSchemaError(53, new Object[]{string});
            return null;
        }
        hashtable = new Hashtable<Object, Object[]>();
        Hashtable hashtable2 = oneElement.attrList;
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = null;
        int n2 = 0;
        while ((attr = (Attr)namedNodeMap.item(n2++)) != null) {
            Object object3;
            Object object4;
            object2 = attr.getName();
            object = attr.getValue();
            if (((String)object2).toLowerCase().startsWith("xml")) {
                hashtable.put(object2, new Object[]{attr.getValue(), Boolean.FALSE});
                continue;
            }
            String string3 = attr.getNamespaceURI();
            if (string3 != null && string3.length() != 0) {
                if (string3.equals("http://www.w3.org/2001/XMLSchema") || !oneElement.allowNonSchemaAttr) {
                    this.reportSchemaError(54, new Object[]{string, object2});
                    continue;
                }
                hashtable.put(object2, new Object[]{object, Boolean.FALSE});
                object4 = string3 + "," + attr.getLocalName();
                object3 = (Vector)this.fNonSchemaAttrs.get(object4);
                if (object3 == null) {
                    object3 = new Vector<String>();
                    ((Vector)object3).addElement(object2);
                    ((Vector)object3).addElement(string);
                    ((Vector)object3).addElement(object);
                    this.fNonSchemaAttrs.put(object4, object3);
                    continue;
                }
                ((Vector)object3).addElement(string);
                ((Vector)object3).addElement(object);
                continue;
            }
            object4 = (OneAttr)hashtable2.get(object2);
            if (object4 == null) {
                this.reportSchemaError(54, new Object[]{string, object2});
                continue;
            }
            try {
                if (((OneAttr)object4).dvIndex >= 0) {
                    if (((OneAttr)object4).dvIndex != DT_STRING && ((OneAttr)object4).dvIndex != DT_XPATH && ((OneAttr)object4).dvIndex != DT_XPATH1) {
                        object3 = fExtraDVs[((OneAttr)object4).dvIndex];
                        if (object3 instanceof IDDatatypeValidator) {
                            object3.validate((String)object, this.fIdDefs);
                        } else {
                            object3.validate((String)object, null);
                        }
                    }
                    hashtable.put(object2, new Object[]{object, Boolean.FALSE});
                    continue;
                }
                object = this.validate((String)object2, (String)object, ((OneAttr)object4).dvIndex);
                hashtable.put(object2, new Object[]{object, Boolean.FALSE});
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                this.reportSchemaError(56, new Object[]{string, object2, invalidDatatypeValueException.getLocalizedMessage()});
            }
        }
        object2 = oneElement.attrArray;
        n2 = 0;
        while (n2 < ((Object)object2).length) {
            object = (OneAttr)object2[n2];
            if (element.getAttributeNode(((OneAttr)object).name) == null) {
                if (((OneAttr)object).optdflt == ATT_REQUIRED) {
                    this.reportSchemaError(55, new Object[]{string, ((OneAttr)object).name});
                } else if (((OneAttr)object).optdflt == ATT_OPT_DFLT) {
                    hashtable.put(((OneAttr)object).name, new Object[]{((OneAttr)object).dfltValue, Boolean.TRUE});
                }
            }
            ++n2;
        }
        this.fProcessedElements.put(element, hashtable);
        return hashtable;
    }

    private String validate(String string, String string2, int n) throws InvalidDatatypeValueException {
        if (string2 == null) {
            return null;
        }
        switch (n) {
            case -1: {
                int n2 = 0;
                if (string2.equals("#all")) {
                    n2 = 47;
                    break;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("substitution")) {
                        n2 |= 0x20;
                        continue;
                    }
                    if (string3.equals("extension")) {
                        n2 |= 1;
                        continue;
                    }
                    if (string3.equals("restriction")) {
                        n2 |= 2;
                        continue;
                    }
                    if (string3.equals("list")) {
                        n2 |= 8;
                        continue;
                    }
                    if (string3.equals("union")) {
                        n2 |= 2;
                        continue;
                    }
                    throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (#all | List of (substitution | extension | restriction | list | union))");
                }
                break;
            }
            case -3: 
            case -2: {
                int n3 = 0;
                if (string2.equals("#all")) {
                    n3 = 3;
                    break;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals("extension")) {
                        n3 |= 1;
                        continue;
                    }
                    if (string4.equals("restriction")) {
                        n3 |= 2;
                        continue;
                    }
                    throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (#all | List of (extension | restriction))");
                }
                break;
            }
            case -4: {
                int n4 = 0;
                if (string2.equals("#all")) {
                    n4 = 14;
                    break;
                }
                if (string2.equals("list")) {
                    n4 = 8;
                    break;
                }
                if (string2.equals("union")) {
                    n4 = 4;
                    break;
                }
                if (string2.equals("restriction")) {
                    n4 = 2;
                    break;
                }
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (#all | (list | union | restriction))");
            }
            case -5: {
                if (string2.equals("qualified") || string2.equals("unqualified")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (qualified | unqualified)");
            }
            case -6: {
                if (string2.equals("unbounded")) break;
                try {
                    fExtraDVs[DT_NONNEGINT].validate(string2, null);
                    break;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (nonNegativeInteger | unbounded)");
                }
            }
            case -7: {
                if (string2.equals("1")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must be '1'");
            }
            case -8: {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        fExtraDVs[DT_QNAME].validate(string5, null);
                    }
                    break;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (List of QName)");
                }
            }
            case -9: {
                if (string2.equals("0") || string2.equals("1")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must be '0' or '1'");
            }
            case -10: {
                if (string2.equals("##any") || string2.equals("##other")) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (string6.equals("##targetNamespace") || string6.equals("##local")) continue;
                        fExtraDVs[DT_ANYURI].validate(string6, null);
                    }
                    break;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeValueException("the value '" + string2 + "' must match ((##any | ##other) | List of (anyURI | (##targetNamespace | ##local)) )");
                }
            }
            case -11: {
                if (string2.equals("skip") || string2.equals("lax") || string2.equals("strict")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (lax | skip | strict)");
            }
            case -12: {
                fExtraDVs[DT_TOKEN].validate(string2, null);
                break;
            }
            case -13: {
                if (string2.equals("optional") || string2.equals("prohibited") || string2.equals("required")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (optional | prohibited | required)");
            }
            case -14: {
                if (string2.equals("preserve") || string2.equals("replace") || string2.equals("collapse")) break;
                throw new InvalidDatatypeValueException("the value '" + string2 + "' must match (preserve | replace | collapse)");
            }
        }
        return string2;
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    public void checkNonSchemaAttributes(GrammarResolver grammarResolver) throws Exception {
        Enumeration enumeration = this.fNonSchemaAttrs.keys();
        while (enumeration.hasMoreElements()) {
            DatatypeValidator datatypeValidator;
            XMLAttributeDecl xMLAttributeDecl;
            SchemaGrammar schemaGrammar;
            Hashtable hashtable;
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf(44));
            String string3 = string.substring(string.indexOf(44) + 1);
            Grammar grammar = grammarResolver.getGrammar(string2);
            if (grammar == null || !(grammar instanceof SchemaGrammar) || (hashtable = (schemaGrammar = (SchemaGrammar)grammar).getAttributeDeclRegistry()) == null || (xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string3)) == null || (datatypeValidator = xMLAttributeDecl.datatypeValidator) == null) continue;
            Vector vector = (Vector)this.fNonSchemaAttrs.get(string);
            String string4 = (String)vector.elementAt(0);
            int n = vector.size();
            int n2 = 1;
            while (n2 < n) {
                String string5 = (String)vector.elementAt(n2);
                String string6 = this.normalize((String)vector.elementAt(n2 + 1), datatypeValidator.getWSFacet());
                try {
                    datatypeValidator.validate(string6, null);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(56, new Object[]{string5, string4, invalidDatatypeValueException.getLocalizedMessage()});
                }
                n2 += 2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String normalize(String var1_1, short var2_2) {
        block8: {
            block7: {
                v0 = var3_3 = var1_1 == null ? 0 : var1_1.length();
                if (var3_3 == 0 || var2_2 == 0) {
                    return var1_1;
                }
                var4_4 = new StringBuffer();
                if (var2_2 != 1) break block7;
                var6_5 = 0;
                while (var6_5 < var3_3) {
                    var5_7 = var1_1.charAt(var6_5);
                    if (var5_7 != '\t' && var5_7 != '\n' && var5_7 != '\r') {
                        var4_4.append(var5_7);
                    } else {
                        var4_4.append(' ');
                    }
                    ++var6_5;
                }
                break block8;
            }
            var7_9 = true;
            var6_6 = 0;
            while (var6_6 < var3_3) {
                block9: {
                    var5_8 = var1_1.charAt(var6_6);
                    if (var5_8 == '\t' || var5_8 == '\n' || var5_8 == '\r' || var5_8 == ' ') ** GOTO lbl30
                    var4_4.append(var5_8);
                    var7_9 = false;
                    break block9;
                    while ((var5_8 = var1_1.charAt(var6_6 + 1)) == '\t' || var5_8 == '\n' || var5_8 == '\r' || var5_8 == ' ') {
                        ++var6_6;
lbl30:
                        // 2 sources

                        if (var6_6 < var3_3 - 1) continue;
                    }
                    if (var6_6 < var3_3 - 1 && !var7_9) {
                        var4_4.append(' ');
                    }
                }
                ++var6_6;
            }
        }
        return var4_4.toString();
    }

    static {
        fExtraDVs = new DatatypeValidator[dtCount];
        int n = 0;
        int n2 = n++;
        int n3 = n++;
        int n4 = n++;
        int n5 = n++;
        int n6 = n++;
        int n7 = n++;
        int n8 = n++;
        int n9 = n++;
        int n10 = n++;
        int n11 = n++;
        int n12 = n++;
        int n13 = n++;
        int n14 = n++;
        int n15 = n++;
        int n16 = n++;
        int n17 = n++;
        int n18 = n++;
        int n19 = n++;
        int n20 = n++;
        int n21 = n++;
        int n22 = n++;
        int n23 = n++;
        int n24 = n++;
        int n25 = n++;
        int n26 = n++;
        int n27 = n++;
        int n28 = n++;
        int n29 = n++;
        int n30 = n++;
        int n31 = n++;
        int n32 = n++;
        int n33 = n++;
        int n34 = n++;
        int n35 = n++;
        int n36 = n++;
        int n37 = n++;
        int n38 = n++;
        int n39 = n++;
        int n40 = n++;
        int n41 = n++;
        int n42 = n++;
        int n43 = n++;
        int n44 = n++;
        int n45 = n++;
        int n46 = n++;
        int n47 = n++;
        OneAttr[] oneAttrArray = new OneAttr[n];
        oneAttrArray[n2] = new OneAttr("abstract", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        oneAttrArray[n3] = new OneAttr("attributeFormDefault", -5, ATT_OPT_DFLT, "unqualified");
        oneAttrArray[n4] = new OneAttr("base", DT_QNAME, ATT_REQUIRED, null);
        oneAttrArray[n5] = new OneAttr("base", DT_QNAME, ATT_OPT_NODFLT, null);
        oneAttrArray[n6] = new OneAttr("block", -1, ATT_OPT_NODFLT, null);
        oneAttrArray[n7] = new OneAttr("block", -2, ATT_OPT_NODFLT, null);
        oneAttrArray[n8] = new OneAttr("blockDefault", -1, ATT_OPT_DFLT, "");
        oneAttrArray[n9] = new OneAttr("default", DT_STRING, ATT_OPT_NODFLT, null);
        oneAttrArray[n10] = new OneAttr("elementFormDefault", -5, ATT_OPT_DFLT, "unqualified");
        oneAttrArray[n11] = new OneAttr("final", -3, ATT_OPT_NODFLT, null);
        oneAttrArray[n12] = new OneAttr("final", -4, ATT_OPT_NODFLT, null);
        oneAttrArray[n13] = new OneAttr("finalDefault", -3, ATT_OPT_DFLT, "");
        oneAttrArray[n14] = new OneAttr("fixed", DT_STRING, ATT_OPT_NODFLT, null);
        oneAttrArray[n15] = new OneAttr("fixed", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        oneAttrArray[n16] = new OneAttr("form", -5, ATT_OPT_NODFLT, null);
        oneAttrArray[n17] = new OneAttr("id", DT_ID, ATT_OPT_NODFLT, null);
        oneAttrArray[n18] = new OneAttr("itemType", DT_QNAME, ATT_OPT_NODFLT, null);
        oneAttrArray[n19] = new OneAttr("maxOccurs", -6, ATT_OPT_DFLT, "1");
        oneAttrArray[n20] = new OneAttr("maxOccurs", -7, ATT_OPT_DFLT, "1");
        oneAttrArray[n21] = new OneAttr("memberTypes", -8, ATT_OPT_NODFLT, null);
        oneAttrArray[n22] = new OneAttr("minOccurs", DT_NONNEGINT, ATT_OPT_DFLT, "1");
        oneAttrArray[n23] = new OneAttr("minOccurs", -9, ATT_OPT_DFLT, "1");
        oneAttrArray[n24] = new OneAttr("mixed", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        oneAttrArray[n25] = new OneAttr("mixed", DT_BOOLEAN, ATT_OPT_NODFLT, null);
        oneAttrArray[n26] = new OneAttr("name", DT_NCNAME, ATT_REQUIRED, null);
        oneAttrArray[n27] = new OneAttr("namespace", -10, ATT_OPT_DFLT, "##any");
        oneAttrArray[n28] = new OneAttr("namespace", DT_ANYURI, ATT_OPT_NODFLT, null);
        oneAttrArray[n29] = new OneAttr("nillable", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        oneAttrArray[n30] = new OneAttr("processContents", -11, ATT_OPT_DFLT, "strict");
        oneAttrArray[n31] = new OneAttr("public", -12, ATT_REQUIRED, null);
        oneAttrArray[n32] = new OneAttr("ref", DT_QNAME, ATT_REQUIRED, null);
        oneAttrArray[n33] = new OneAttr("refer", DT_QNAME, ATT_REQUIRED, null);
        oneAttrArray[n34] = new OneAttr("schemaLocation", DT_ANYURI, ATT_REQUIRED, null);
        oneAttrArray[n35] = new OneAttr("schemaLocation", DT_ANYURI, ATT_OPT_NODFLT, null);
        oneAttrArray[n36] = new OneAttr("source", DT_ANYURI, ATT_OPT_NODFLT, null);
        oneAttrArray[n37] = new OneAttr("substitutionGroup", DT_QNAME, ATT_OPT_NODFLT, null);
        oneAttrArray[n38] = new OneAttr("system", DT_ANYURI, ATT_OPT_NODFLT, null);
        oneAttrArray[n39] = new OneAttr("targetNamespace", DT_ANYURI, ATT_OPT_NODFLT, null);
        oneAttrArray[n40] = new OneAttr("type", DT_QNAME, ATT_OPT_NODFLT, null);
        oneAttrArray[n41] = new OneAttr("use", -13, ATT_OPT_DFLT, "optional");
        oneAttrArray[n42] = new OneAttr("value", DT_NONNEGINT, ATT_OPT_NODFLT, null);
        oneAttrArray[n43] = new OneAttr("value", DT_STRING, ATT_OPT_NODFLT, null);
        oneAttrArray[n44] = new OneAttr("value", -14, ATT_OPT_NODFLT, null);
        oneAttrArray[n45] = new OneAttr("version", DT_TOKEN, ATT_OPT_NODFLT, null);
        oneAttrArray[n46] = new OneAttr("xpath", DT_XPATH, ATT_REQUIRED, null);
        oneAttrArray[n47] = new OneAttr("xpath", DT_XPATH1, ATT_REQUIRED, null);
        Hashtable<String, OneAttr> hashtable = new Hashtable<String, OneAttr>();
        hashtable.put("default", oneAttrArray[n9]);
        hashtable.put("fixed", oneAttrArray[n14]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("type", oneAttrArray[n40]);
        OneElement oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "attribute", oneElement);
        hashtable = new Hashtable();
        hashtable.put("default", oneAttrArray[n9]);
        hashtable.put("fixed", oneAttrArray[n14]);
        hashtable.put("form", oneAttrArray[n16]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("type", oneAttrArray[n40]);
        hashtable.put("use", oneAttrArray[n41]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "attribute", oneElement);
        hashtable = new Hashtable();
        hashtable.put("default", oneAttrArray[n9]);
        hashtable.put("fixed", oneAttrArray[n14]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("ref", oneAttrArray[n32]);
        hashtable.put("use", oneAttrArray[n41]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_REF + "attribute", oneElement);
        hashtable = new Hashtable();
        hashtable.put("abstract", oneAttrArray[n2]);
        hashtable.put("block", oneAttrArray[n6]);
        hashtable.put("default", oneAttrArray[n9]);
        hashtable.put("final", oneAttrArray[n11]);
        hashtable.put("fixed", oneAttrArray[n14]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("nillable", oneAttrArray[n29]);
        hashtable.put("substitutionGroup", oneAttrArray[n37]);
        hashtable.put("type", oneAttrArray[n40]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "element", oneElement);
        hashtable = new Hashtable();
        hashtable.put("block", oneAttrArray[n6]);
        hashtable.put("default", oneAttrArray[n9]);
        hashtable.put("fixed", oneAttrArray[n14]);
        hashtable.put("form", oneAttrArray[n16]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n19]);
        hashtable.put("minOccurs", oneAttrArray[n22]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("nillable", oneAttrArray[n29]);
        hashtable.put("type", oneAttrArray[n40]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "element", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n19]);
        hashtable.put("minOccurs", oneAttrArray[n22]);
        hashtable.put("ref", oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_REF + "element", oneElement);
        hashtable = new Hashtable();
        hashtable.put("abstract", oneAttrArray[n2]);
        hashtable.put("block", oneAttrArray[n7]);
        hashtable.put("final", oneAttrArray[n11]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("mixed", oneAttrArray[n24]);
        hashtable.put("name", oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "complexType", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("mixed", oneAttrArray[n24]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "complexType", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "simpleContent", oneElement);
        hashtable = new Hashtable();
        hashtable.put("base", oneAttrArray[n5]);
        hashtable.put("id", oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "restriction", oneElement);
        hashtable = new Hashtable();
        hashtable.put("base", oneAttrArray[n4]);
        hashtable.put("id", oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "extension", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("ref", oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_REF + "attributeGroup", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("namespace", oneAttrArray[n27]);
        hashtable.put("processContents", oneAttrArray[n30]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "anyAttribute", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("mixed", oneAttrArray[n25]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "complexContent", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "attributeGroup", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "group", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n19]);
        hashtable.put("minOccurs", oneAttrArray[n22]);
        hashtable.put("ref", oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_REF + "group", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n20]);
        hashtable.put("minOccurs", oneAttrArray[n23]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "all", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n19]);
        hashtable.put("minOccurs", oneAttrArray[n22]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "choice", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "sequence", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("maxOccurs", oneAttrArray[n19]);
        hashtable.put("minOccurs", oneAttrArray[n22]);
        hashtable.put("namespace", oneAttrArray[n27]);
        hashtable.put("processContents", oneAttrArray[n30]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "any", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "unique", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "key", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("refer", oneAttrArray[n33]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "keyref", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("xpath", oneAttrArray[n46]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "selector", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("xpath", oneAttrArray[n47]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "field", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        hashtable.put("public", oneAttrArray[n31]);
        hashtable.put("system", oneAttrArray[n38]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "notation", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "annotation", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "annotation", oneElement);
        hashtable = new Hashtable();
        hashtable.put("source", oneAttrArray[n36]);
        oneElement = new OneElement(hashtable, false);
        fEleAttrsMap.put(PRE_LOC_NAME + "appinfo", oneElement);
        hashtable = new Hashtable();
        hashtable.put("source", oneAttrArray[n36]);
        oneElement = new OneElement(hashtable, false);
        fEleAttrsMap.put(PRE_LOC_NAME + "documentation", oneElement);
        hashtable = new Hashtable();
        hashtable.put("final", oneAttrArray[n12]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("name", oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "simpleType", oneElement);
        hashtable = new Hashtable();
        hashtable.put("final", oneAttrArray[n12]);
        hashtable.put("id", oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "simpleType", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("itemType", oneAttrArray[n18]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "list", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("memberTypes", oneAttrArray[n21]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "union", oneElement);
        hashtable = new Hashtable();
        hashtable.put("attributeFormDefault", oneAttrArray[n3]);
        hashtable.put("blockDefault", oneAttrArray[n8]);
        hashtable.put("elementFormDefault", oneAttrArray[n10]);
        hashtable.put("finalDefault", oneAttrArray[n13]);
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("targetNamespace", oneAttrArray[n39]);
        hashtable.put("version", oneAttrArray[n45]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "schema", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("schemaLocation", oneAttrArray[n34]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "include", oneElement);
        fEleAttrsMap.put(PRE_GLOBAL + "redefine", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("namespace", oneAttrArray[n28]);
        hashtable.put("schemaLocation", oneAttrArray[n35]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_GLOBAL + "import", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("value", oneAttrArray[n42]);
        hashtable.put("fixed", oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "length", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "minLength", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "maxLength", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "totalDigits", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "fractionDigits", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("value", oneAttrArray[n43]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "pattern", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("value", oneAttrArray[n43]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "enumeration", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("value", oneAttrArray[n44]);
        hashtable.put("fixed", oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "whiteSpace", oneElement);
        hashtable = new Hashtable();
        hashtable.put("id", oneAttrArray[n17]);
        hashtable.put("value", oneAttrArray[n43]);
        hashtable.put("fixed", oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMap.put(PRE_LOC_NAME + "maxInclusive", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "maxExclusive", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "minInclusive", oneElement);
        fEleAttrsMap.put(PRE_LOC_NAME + "minExclusive", oneElement);
    }
}

