/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class ListDatatypeValidator
extends AbstractDatatypeValidator {
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private Vector fEnumeration = null;

    public ListDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ListDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.fBaseValidator = datatypeValidator;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("length")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    string = (String)hashtable.get(string2);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("minLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("maxLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("enumeration")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = (Vector)hashtable.get(string2);
                    continue;
                }
                if (string2.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)hashtable.get(string2);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_LIST_FACET, 0, new Object[]{string2}));
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
            }
            if (datatypeValidator != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int n = 0;
                try {
                    while (n < this.fEnumeration.size()) {
                        datatypeValidator.validate((String)this.fEnumeration.elementAt(n), null);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(n) + "' must be from the value space of base.");
                }
            }
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (string == null && object != null) {
            this.fBaseValidator.validate(string, object);
        } else {
            this.checkContentEnum(string, object, null);
        }
        return null;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String string, String string2) {
        if (this.fBaseValidator instanceof ListDatatypeValidator) {
            return ((ListDatatypeValidator)this.fBaseValidator).compare(string, string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        if (n < stringTokenizer2.countTokens()) {
            return -1;
        }
        if (n > stringTokenizer2.countTokens()) {
            return 1;
        }
        int n2 = 0;
        while (n2++ < n) {
            int n3;
            if (this.fBaseValidator == null || (n3 = this.fBaseValidator.compare(stringTokenizer.nextToken(), stringTokenizer2.nextToken())) == 0) continue;
            return n3;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        ListDatatypeValidator listDatatypeValidator = null;
        try {
            listDatatypeValidator = new ListDatatypeValidator();
            listDatatypeValidator.fLocale = this.fLocale;
            listDatatypeValidator.fBaseValidator = this.fBaseValidator;
            listDatatypeValidator.fLength = this.fLength;
            listDatatypeValidator.fMaxLength = this.fMaxLength;
            listDatatypeValidator.fMinLength = this.fMinLength;
            listDatatypeValidator.fPattern = this.fPattern;
            listDatatypeValidator.fEnumeration = this.fEnumeration;
            listDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return listDatatypeValidator;
    }

    protected void checkContentEnum(String string, Object object, Vector vector) throws InvalidDatatypeValueException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (this.fBaseValidator instanceof ListDatatypeValidator) {
            try {
                if ((this.fFacetsDefined & 4) != 0 && n > this.fMaxLength) {
                    throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' exceeds maximum length facet of '" + this.fMaxLength + "' tokens.");
                }
                if ((this.fFacetsDefined & 2) != 0 && n < this.fMinLength) {
                    throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' is less than minimum length facet of '" + this.fMinLength + "' tokens.");
                }
                if ((this.fFacetsDefined & 1) != 0 && n != this.fLength) {
                    throw new InvalidDatatypeValueException("Value '" + string + "' with length ='" + n + "' tokens" + "' is not equal to length facet of '" + this.fLength + "' tokens.");
                }
                if (vector != null) {
                    if (!this.verifyEnum(vector)) {
                        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{vector}));
                    }
                } else {
                    vector = this.fEnumeration != null ? this.fEnumeration : null;
                }
                ((ListDatatypeValidator)this.fBaseValidator).checkContentEnum(string, object, vector);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
        } else if (vector != null) {
            StringTokenizer stringTokenizer2 = null;
            StringTokenizer stringTokenizer3 = null;
            String string2 = null;
            String string3 = null;
            boolean bl = true;
            int n2 = vector.size();
            Vector<String> vector2 = new Vector<String>();
            vector2.setSize(1);
            String string4 = null;
            int n3 = 0;
            while (n3 < n2) {
                string4 = (String)vector.elementAt(n3);
                stringTokenizer2 = new StringTokenizer(string4);
                bl = true;
                StringTokenizer stringTokenizer4 = stringTokenizer3 = n3 == 0 ? stringTokenizer : new StringTokenizer(string);
                if (n == stringTokenizer2.countTokens()) {
                    try {
                        int n4;
                        if (string4.equals(string)) {
                            n4 = 0;
                            while (n4 < n) {
                                if (this.fBaseValidator != null) {
                                    this.fBaseValidator.validate(stringTokenizer3.nextToken(), object);
                                }
                                ++n4;
                            }
                        } else {
                            n4 = 0;
                            while (n4 < n) {
                                string2 = stringTokenizer3.nextToken();
                                string3 = stringTokenizer2.nextToken();
                                vector2.setElementAt(string3, 0);
                                if (this.fBaseValidator instanceof AbstractNumericValidator) {
                                    ((AbstractNumericValidator)this.fBaseValidator).checkContentEnum(string2, object, vector2);
                                } else {
                                    if (!string2.equals(string3)) {
                                        throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + vector);
                                    }
                                    this.fBaseValidator.validate(string2, object);
                                }
                                ++n4;
                            }
                        }
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                ++n3;
            }
            if (!bl) {
                throw new InvalidDatatypeValueException("Value '" + string + "' does not match list type");
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                if (this.fBaseValidator != null) {
                    this.fBaseValidator.validate(stringTokenizer.nextToken(), object);
                }
                ++n5;
            }
        }
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (this.fEnumeration.contains(enumeration.nextElement())) continue;
                return false;
            }
        }
        return true;
    }
}

