/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public abstract class AbstractNumericFacetValidator
extends AbstractDatatypeValidator {
    protected Object[] fEnumeration = null;
    protected Object fMaxInclusive = null;
    protected Object fMaxExclusive = null;
    protected Object fMinInclusive = null;
    protected Object fMinExclusive = null;
    protected static final short INDETERMINATE = 2;

    public AbstractNumericFacetValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public AbstractNumericFacetValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.fBaseValidator = datatypeValidator;
        if (bl) {
            return;
        }
        this.initializeValues();
        if (hashtable != null) {
            int n;
            Object object;
            Vector vector = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string = null;
                try {
                    if (((String)object).equals("pattern")) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        this.fPattern = (String)hashtable.get(object);
                        if (this.fPattern == null) continue;
                        this.fRegex = new RegularExpression(this.fPattern, "X");
                        continue;
                    }
                    if (((String)object).equals("enumeration")) {
                        vector = (Vector)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        continue;
                    }
                    if (((String)object).equals("maxInclusive")) {
                        string = (String)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                        this.setMaxInclusive(string);
                        continue;
                    }
                    if (((String)object).equals("maxExclusive")) {
                        string = (String)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                        this.setMaxExclusive(string);
                        continue;
                    }
                    if (((String)object).equals("minInclusive")) {
                        string = (String)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                        this.setMinInclusive(string);
                        continue;
                    }
                    if (((String)object).equals("minExclusive")) {
                        string = (String)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                        this.setMinExclusive(string);
                        continue;
                    }
                    if (((String)object).equals("fixed")) {
                        this.fFlags = (Short)hashtable.get(object);
                        continue;
                    }
                    this.assignAdditionalFacets((String)object, hashtable);
                }
                catch (Exception exception) {
                    if (string == null) {
                        throw new InvalidDatatypeFacetException(exception.getMessage());
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_FACET_VALUE, 0, new Object[]{string, object}));
                }
            }
            if (this.fFacetsDefined != 0) {
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMinInclusive, this.fMaxInclusive)) == 1 || n == 2)) {
                    throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be <= maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && ((n = this.compareValues(this.fMinExclusive, this.fMaxExclusive)) == 1 || n == 2)) {
                    throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be <= maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinExclusive, this.fMaxInclusive) != -1) {
                    throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be > maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMinInclusive, this.fMaxExclusive) != -1) {
                    throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be < maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                }
                this.checkFacetConstraints();
            }
            if (datatypeValidator != null) {
                object = (AbstractNumericFacetValidator)datatypeValidator;
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x20) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0) {
                            n = this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x20) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("maxInclusive value = '" + this.getMaxInclusive(false) + "' must be equal to base.maxInclusive value = '" + this.getMaxInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == 1 || n == 2) {
                                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMinInclusive)) == -1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x40) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0) {
                            n = this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x40) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("maxExclusive value = '" + this.getMaxExclusive(false) + "' must be equal to base.maxExclusive value = '" + this.getMaxExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == 1 || n == 2) {
                                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMinInclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x100) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0) {
                            n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMinExclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x100) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("minExclusive value = '" + this.getMinExclusive(false) + "' must be equal to base.minExclusive value = '" + this.getMinExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == -1 || n == 2) {
                                throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMinInclusive)) == -1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x80) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0) {
                            n = this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMinInclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x80) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("minInclusive value = '" + this.getMinInclusive(false) + "' must be equal to base.minInclusive value = '" + this.getMinInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == -1 || n == 2) {
                                throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    this.checkBaseFacetConstraints();
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (((AbstractDatatypeValidator)object).fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = ((AbstractNumericFacetValidator)object).fEnumeration;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    this.fMaxExclusive = ((AbstractNumericFacetValidator)object).fMaxExclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                    this.fMaxInclusive = ((AbstractNumericFacetValidator)object).fMaxInclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    this.fMinExclusive = ((AbstractNumericFacetValidator)object).fMinExclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    this.fMinInclusive = ((AbstractNumericFacetValidator)object).fMinInclusive;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | ((AbstractDatatypeValidator)object).fFlags);
                if ((this.fFacetsDefined & 0x10) != 0 && vector != null) {
                    try {
                        this.setEnumeration(vector);
                    }
                    catch (Exception exception) {
                        throw new InvalidDatatypeFacetException(exception.getMessage());
                    }
                }
            }
        }
    }

    protected abstract int compareValues(Object var1, Object var2);

    protected abstract void setMaxInclusive(String var1);

    protected abstract void setMinInclusive(String var1);

    protected abstract void setMaxExclusive(String var1);

    protected abstract void setMinExclusive(String var1);

    protected abstract void setEnumeration(Vector var1) throws InvalidDatatypeValueException;

    protected abstract String getMaxInclusive(boolean var1);

    protected abstract String getMinInclusive(boolean var1);

    protected abstract String getMaxExclusive(boolean var1);

    protected abstract String getMinExclusive(boolean var1);

    protected void initializeValues() {
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void inheritAdditionalFacets() {
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
    }
}

