/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class ElementWildcard {
    private ElementWildcard() {
    }

    private static boolean uriInWildcard(QName qName, int n, int n2, SubstitutionGroupComparator substitutionGroupComparator) throws Exception {
        int n3 = n2 & 0xF;
        if (n3 == 6) {
            return true;
        }
        return n3 == 8 ? (substitutionGroupComparator != null ? substitutionGroupComparator.isAllowedByWildcard(qName, n, false) : qName.uri == n) : n3 == 7 && (substitutionGroupComparator != null ? substitutionGroupComparator.isAllowedByWildcard(qName, n, true) : n != qName.uri);
    }

    private static boolean wildcardIntersect(int n, int n2, int n3, int n4) {
        int n5 = n2 & 0xF;
        int n6 = n4 & 0xF;
        if (n5 == 6 || n6 == 6) {
            return true;
        }
        if (n5 == 8 && n6 == 8 && n == n3) {
            return true;
        }
        if (n5 == 7 && n6 == 7) {
            return true;
        }
        return (n5 == 8 && n6 == 7 || n5 == 7 && n6 == 8) && n != n3;
    }

    private static boolean conflic(int n, int n2, int n3, int n4, int n5, int n6, SubstitutionGroupComparator substitutionGroupComparator) throws Exception {
        QName qName = new QName();
        QName qName2 = new QName();
        qName.localpart = n2;
        qName.uri = n3;
        qName2.localpart = n5;
        qName2.uri = n6;
        return n == 0 && n4 == 0 ? (substitutionGroupComparator != null ? substitutionGroupComparator.isEquivalentTo(qName, qName2) || substitutionGroupComparator.isEquivalentTo(qName2, qName) : qName.localpart == qName2.localpart && qName.uri == qName2.uri) : (n == 0 ? ElementWildcard.uriInWildcard(qName, n6, n4, substitutionGroupComparator) : (n4 == 0 ? ElementWildcard.uriInWildcard(qName2, n3, n, substitutionGroupComparator) : ElementWildcard.wildcardIntersect(n3, n, n6, n4)));
    }

    public static boolean conflict(int n, int n2, int n3, int n4, int n5, int n6, SubstitutionGroupComparator substitutionGroupComparator) throws Exception {
        boolean bl = ElementWildcard.conflic(n, n2, n3, n4, n5, n6, substitutionGroupComparator);
        if (bl && substitutionGroupComparator != null) {
            StringPool stringPool = substitutionGroupComparator.getStringPool();
            XMLErrorReporter xMLErrorReporter = substitutionGroupComparator.getErrorReporter();
            xMLErrorReporter.reportError(xMLErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 52, 0, new Object[]{ElementWildcard.eleString(n, n2, n3, stringPool), ElementWildcard.eleString(n4, n5, n6, stringPool)}, 1);
        }
        return bl;
    }

    private static String eleString(int n, int n2, int n3, StringPool stringPool) {
        switch (n & 0xF) {
            case 0: {
                return stringPool.toString(n3) + "," + stringPool.toString(n2);
            }
            case 6: {
                return "##any,*";
            }
            case 8: {
                return "##any(" + stringPool.toString(n3) + "),*";
            }
            case 7: {
                return "##other(" + stringPool.toString(n3) + "),*";
            }
        }
        return "";
    }
}

