/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends ChildNode {
    static final long serialVersionUID = 2815829867152120872L;
    protected CoreDocumentImpl ownerDocument;
    protected ChildNode firstChild = null;
    protected transient int fCachedLength = -1;
    protected transient ChildNode fCachedChild;
    protected transient int fCachedChildIndex = -1;

    protected ParentNode(CoreDocumentImpl coreDocumentImpl) {
        super(coreDocumentImpl);
        this.ownerDocument = coreDocumentImpl;
    }

    public ParentNode() {
    }

    public Node cloneNode(boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ParentNode parentNode = (ParentNode)super.cloneNode(bl);
        parentNode.ownerDocument = this.ownerDocument;
        parentNode.firstChild = null;
        parentNode.fCachedChildIndex = -1;
        parentNode.fCachedLength = -1;
        if (bl) {
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                parentNode.appendChild(childNode.cloneNode(true));
                childNode = childNode.nextSibling;
            }
        }
        return parentNode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    CoreDocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(coreDocumentImpl);
        this.ownerDocument = coreDocumentImpl;
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            childNode.setOwnerDocument(coreDocumentImpl);
            childNode = childNode.nextSibling;
        }
    }

    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    final ChildNode lastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    final void lastChild(ChildNode childNode) {
        if (this.firstChild != null) {
            this.firstChild.previousSibling = childNode;
        }
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, false);
    }

    Node internalInsertBefore(Node node, Node node2, boolean bl) throws DOMException {
        NodeImpl nodeImpl;
        boolean bl2 = this.ownerDocument.errorChecking;
        if (node.getNodeType() == 11) {
            if (bl2) {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    if (!this.ownerDocument.isKidOK(this, node3)) {
                        throw new DOMException(3, "DOM006 Hierarchy request error");
                    }
                    node3 = node3.getNextSibling();
                }
            }
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
            return node;
        }
        if (node == node2) {
            node2 = node2.getNextSibling();
            this.removeChild(node);
            this.insertBefore(node, node2);
            return node;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl2) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node.getOwnerDocument() != this.ownerDocument) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            if (!this.ownerDocument.isKidOK(this, node)) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
            boolean bl3 = true;
            nodeImpl = this;
            while (bl3 && nodeImpl != null) {
                bl3 = node != nodeImpl;
                nodeImpl = nodeImpl.parentNode();
            }
            if (!bl3) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
        }
        this.ownerDocument.insertingNode(this, bl);
        ChildNode childNode = (ChildNode)node;
        nodeImpl = childNode.parentNode();
        if (nodeImpl != null) {
            nodeImpl.removeChild(childNode);
        }
        ChildNode childNode2 = (ChildNode)node2;
        childNode.ownerNode = this;
        childNode.isOwned(true);
        if (this.firstChild == null) {
            this.firstChild = childNode;
            childNode.isFirstChild(true);
            childNode.previousSibling = childNode;
        } else if (childNode2 == null) {
            ChildNode childNode3 = this.firstChild.previousSibling;
            childNode3.nextSibling = childNode;
            childNode.previousSibling = childNode3;
            this.firstChild.previousSibling = childNode;
        } else if (node2 == this.firstChild) {
            this.firstChild.isFirstChild(false);
            childNode.nextSibling = this.firstChild;
            childNode.previousSibling = this.firstChild.previousSibling;
            this.firstChild.previousSibling = childNode;
            this.firstChild = childNode;
            childNode.isFirstChild(true);
        } else {
            ChildNode childNode4 = childNode2.previousSibling;
            childNode.nextSibling = childNode2;
            childNode4.nextSibling = childNode;
            childNode2.previousSibling = childNode;
            childNode.previousSibling = childNode4;
        }
        this.changed();
        if (this.fCachedLength != -1) {
            ++this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == childNode2) {
                this.fCachedChild = childNode;
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        this.ownerDocument.insertedNode(this, childNode, bl);
        this.checkNormalizationAfterInsert(childNode);
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, false);
    }

    Node internalRemoveChild(Node node, boolean bl) throws DOMException {
        ChildNode childNode;
        CoreDocumentImpl coreDocumentImpl = this.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node != null && node.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
        }
        ChildNode childNode2 = (ChildNode)node;
        coreDocumentImpl.removingNode(this, childNode2, bl);
        if (this.fCachedLength != -1) {
            --this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == childNode2) {
                --this.fCachedChildIndex;
                this.fCachedChild = childNode2.previousSibling();
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        if (childNode2 == this.firstChild) {
            childNode2.isFirstChild(false);
            this.firstChild = childNode2.nextSibling;
            if (this.firstChild != null) {
                this.firstChild.isFirstChild(true);
                this.firstChild.previousSibling = childNode2.previousSibling;
            }
        } else {
            ChildNode childNode3;
            childNode = childNode2.previousSibling;
            childNode.nextSibling = childNode3 = childNode2.nextSibling;
            if (childNode3 == null) {
                this.firstChild.previousSibling = childNode;
            } else {
                childNode3.previousSibling = childNode;
            }
        }
        childNode = childNode2.previousSibling();
        childNode2.ownerNode = coreDocumentImpl;
        childNode2.isOwned(false);
        childNode2.nextSibling = null;
        childNode2.previousSibling = null;
        this.changed();
        coreDocumentImpl.removedNode(this, bl);
        this.checkNormalizationAfterRemove(childNode);
        return childNode2;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.ownerDocument.replacingNode(this);
        this.internalInsertBefore(node, node2, true);
        if (node != node2) {
            this.internalRemoveChild(node2, true);
        }
        this.ownerDocument.replacedNode(this);
        return node2;
    }

    private int nodeListGetLength() {
        if (this.fCachedLength == -1) {
            ChildNode childNode;
            if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
                this.fCachedLength = this.fCachedChildIndex;
                childNode = this.fCachedChild;
            } else {
                childNode = this.firstChild;
                this.fCachedLength = 0;
            }
            while (childNode != null) {
                ++this.fCachedLength;
                childNode = childNode.nextSibling;
            }
        }
        return this.fCachedLength;
    }

    public int getLength() {
        return this.nodeListGetLength();
    }

    private Node nodeListItem(int n) {
        if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
            if (this.fCachedChildIndex < n) {
                while (this.fCachedChildIndex < n && this.fCachedChild != null) {
                    ++this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.nextSibling;
                }
            } else if (this.fCachedChildIndex > n) {
                while (this.fCachedChildIndex > n && this.fCachedChild != null) {
                    --this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.previousSibling();
                }
            }
            return this.fCachedChild;
        }
        this.fCachedChild = this.firstChild;
        this.fCachedChildIndex = 0;
        while (this.fCachedChildIndex < n && this.fCachedChild != null) {
            this.fCachedChild = this.fCachedChild.nextSibling;
            ++this.fCachedChildIndex;
        }
        return this.fCachedChild;
    }

    public Node item(int n) {
        return this.nodeListItem(n);
    }

    protected final NodeList getChildNodesUnoptimized() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return new NodeList(){

            public int getLength() {
                return ParentNode.this.nodeListGetLength();
            }

            public Node item(int n) {
                return ParentNode.this.nodeListItem(n);
            }
        };
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            childNode.normalize();
            childNode = childNode.nextSibling;
        }
        this.isNormalized(true);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                if (childNode.getNodeType() != 5) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    void checkNormalizationAfterInsert(ChildNode childNode) {
        if (childNode.getNodeType() == 3) {
            ChildNode childNode2 = childNode.previousSibling();
            ChildNode childNode3 = childNode.nextSibling;
            if (childNode2 != null && childNode2.getNodeType() == 3 || childNode3 != null && childNode3.getNodeType() == 3) {
                this.isNormalized(false);
            }
        } else if (!childNode.isNormalized()) {
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode childNode) {
        ChildNode childNode2;
        if (childNode != null && childNode.getNodeType() == 3 && (childNode2 = childNode.nextSibling) != null && childNode2.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
        this.fCachedLength = -1;
        this.fCachedChildIndex = -1;
    }
}

