/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.viewer;

import uk.ac.man.bioinf.gui.viewer.AlignmentSelectionModel;
import uk.ac.man.bioinf.gui.viewer.event.AlignmentSelectionEvent;
import uk.ac.man.bioinf.gui.viewer.event.AlignmentSelectionListener;
import uk.ac.man.bioinf.gui.viewer.event.AlignmentSelectionListenerSupport;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;

public class SingleAlignmentSelectionModel
implements AlignmentSelectionModel {
    private boolean isSelecting = false;
    private SequenceAlignmentRectangle currentSelection = new SequenceAlignmentRectangle();
    private AlignmentSelectionListenerSupport list = new AlignmentSelectionListenerSupport();
    private SequenceAlignmentPoint start;
    private SequenceAlignmentPoint stop;

    public boolean isSelecting() {
        return this.isSelecting;
    }

    public SequenceAlignmentRectangle getCurrentSelection() {
        if (this.start == null) {
            return null;
        }
        return this.currentSelection;
    }

    public int getNumberSelections() {
        return this.start == null ? 0 : 1;
    }

    public SequenceAlignmentRectangle getSelectionAt(int n) throws ArrayIndexOutOfBoundsException {
        if (this.start == null || n > 0) {
            throw new ArrayIndexOutOfBoundsException("No such selection rectangle");
        }
        return this.getCurrentSelection();
    }

    public boolean isPointSelected(SequenceAlignmentPoint sequenceAlignmentPoint) {
        SequenceAlignmentRectangle sequenceAlignmentRectangle = this.getCurrentSelection();
        return sequenceAlignmentRectangle != null ? sequenceAlignmentRectangle.contains(sequenceAlignmentPoint) : false;
    }

    public void clearSelection() {
        SequenceAlignmentRectangle sequenceAlignmentRectangle = this.getCurrentSelection();
        this.stop = null;
        this.start = null;
        this.list.fireAlignmentSelectionEvent(new AlignmentSelectionEvent(this, sequenceAlignmentRectangle, false));
        this.isSelecting = false;
    }

    public SequenceAlignmentRectangle getRectangleAtPoint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        SequenceAlignmentRectangle sequenceAlignmentRectangle = this.getCurrentSelection();
        if (sequenceAlignmentRectangle.contains(sequenceAlignmentPoint)) {
            return sequenceAlignmentRectangle;
        }
        return null;
    }

    public SequenceAlignmentRectangle[] getRectanglesAtPoint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        SequenceAlignmentRectangle sequenceAlignmentRectangle = this.getRectangleAtPoint(sequenceAlignmentPoint);
        if (sequenceAlignmentRectangle == null) {
            return null;
        }
        SequenceAlignmentRectangle[] sequenceAlignmentRectangleArray = new SequenceAlignmentRectangle[]{sequenceAlignmentRectangle};
        return sequenceAlignmentRectangleArray;
    }

    private void recalcSelectionRectangle() {
        this.currentSelection.setLocation(this.start);
        this.currentSelection.setSize(1, 1);
        this.currentSelection.add(this.stop);
    }

    public void extendSelection(SequenceAlignmentPoint sequenceAlignmentPoint) {
        if (this.start == null || !this.isSelecting) {
            this.start = sequenceAlignmentPoint;
            this.isSelecting = true;
        }
        this.stop = sequenceAlignmentPoint;
        this.recalcSelectionRectangle();
        this.list.fireAlignmentSelectionEvent(new AlignmentSelectionEvent(this, this.getCurrentSelection(), this.isSelecting));
    }

    public void stopSelection(SequenceAlignmentPoint sequenceAlignmentPoint) {
        if (this.start == null || !this.isSelecting) {
            this.start = sequenceAlignmentPoint;
        }
        this.stop = sequenceAlignmentPoint;
        this.recalcSelectionRectangle();
        this.isSelecting = false;
        this.list.fireAlignmentSelectionEvent(new AlignmentSelectionEvent(this, this.getCurrentSelection(), this.isSelecting));
    }

    public void addAlignmentSelectionListener(AlignmentSelectionListener alignmentSelectionListener) {
        this.list.addAlignmentSelectionListener(alignmentSelectionListener);
    }

    public void removeAlignmentSelectionListener(AlignmentSelectionListener alignmentSelectionListener) {
        this.list.addAlignmentSelectionListener(alignmentSelectionListener);
    }
}

