/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.viewer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import uk.ac.man.bioinf.gui.color.ColorMap;
import uk.ac.man.bioinf.gui.color.SingleColorMap;
import uk.ac.man.bioinf.gui.viewer.AlignmentSelectionModel;
import uk.ac.man.bioinf.gui.viewer.AlignmentSelectionRenderer;
import uk.ac.man.bioinf.gui.viewer.AlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.DefaultAlignmentSelectionRenderer;
import uk.ac.man.bioinf.gui.viewer.DefaultFastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.DefaultSequenceCursor;
import uk.ac.man.bioinf.gui.viewer.FastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.ReadonlyException;
import uk.ac.man.bioinf.gui.viewer.SequenceCursor;
import uk.ac.man.bioinf.gui.viewer.SingleAlignmentSelectionModel;
import uk.ac.man.bioinf.gui.viewer.event.AlignmentSelectionEvent;
import uk.ac.man.bioinf.gui.viewer.event.AlignmentSelectionListener;
import uk.ac.man.bioinf.gui.viewer.plaf.AlignmentViewerUI;
import uk.ac.man.bioinf.sequence.alignment.EmptySequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoGapAtThisPositionException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentVetoException;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;

public class JAlignmentViewer
extends JComponent
implements AlignmentListener,
SequenceListener,
AlignmentSelectionListener {
    public static final String uiClassID = "AlignmentViewerUI";
    private SequenceAlignment alignment;
    private Dimension prototypicalCellSize = new Dimension(30, 30);
    private AlignmentViewerCellRenderer renderer;
    private FastAlignmentViewerCellRenderer fastRenderer = new DefaultFastAlignmentViewerCellRenderer();
    private AlignmentSelectionRenderer selectionRenderer = new DefaultAlignmentSelectionRenderer();
    private SequenceCursor cursor;
    private AlignmentViewerUI viewerUI;
    private AlignmentSelectionModel selectionModel;
    private ColorMap colorMap;
    private Dimension preferredSize = new Dimension(0, 0);
    private Rectangle cacheRect;
    protected boolean readonly = false;
    private Rectangle viewerRect = null;
    private SequenceAlignmentRectangle previousSelection;
    static /* synthetic */ Class class$uk$ac$man$bioinf$gui$viewer$Install;

    public JAlignmentViewer() {
        this((SequenceAlignment)EmptySequenceAlignment.getInstance());
    }

    public JAlignmentViewer(SequenceAlignment sequenceAlignment) {
        this.alignment = sequenceAlignment;
        this.cursor = new DefaultSequenceCursor();
        this.colorMap = new SingleColorMap(this.getBackground());
        this.selectionModel = new SingleAlignmentSelectionModel();
        this.selectionModel.addAlignmentSelectionListener(this);
        this.updateUI();
    }

    public void setCellRenderer(AlignmentViewerCellRenderer alignmentViewerCellRenderer) {
        AlignmentViewerCellRenderer alignmentViewerCellRenderer2 = this.renderer;
        this.renderer = alignmentViewerCellRenderer;
        this.firePropertyChange("cellRenderer", alignmentViewerCellRenderer2, alignmentViewerCellRenderer);
    }

    public AlignmentViewerCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public void setFastCellRenderer(FastAlignmentViewerCellRenderer fastAlignmentViewerCellRenderer) {
        FastAlignmentViewerCellRenderer fastAlignmentViewerCellRenderer2 = this.fastRenderer;
        this.fastRenderer = fastAlignmentViewerCellRenderer;
        this.firePropertyChange("fastCellRenderer", fastAlignmentViewerCellRenderer2, fastAlignmentViewerCellRenderer);
    }

    public FastAlignmentViewerCellRenderer getFastCellRenderer() {
        return this.fastRenderer;
    }

    public void setAlignmentSelectionRenderer(AlignmentSelectionRenderer alignmentSelectionRenderer) {
        AlignmentSelectionRenderer alignmentSelectionRenderer2 = this.selectionRenderer;
        this.selectionRenderer = alignmentSelectionRenderer;
        this.firePropertyChange("alignmentSelectionRenderer", alignmentSelectionRenderer2, alignmentSelectionRenderer);
    }

    public AlignmentSelectionRenderer getAlignmentSelectionRenderer() {
        return this.selectionRenderer;
    }

    public void setCellHeight(int n) {
        int n2 = this.prototypicalCellSize.height;
        this.prototypicalCellSize.height = n;
        this.firePropertyChange("cellHeight", n2, n);
    }

    public int getCellHeight() {
        return this.prototypicalCellSize.height;
    }

    public void setCellWidth(int n) {
        int n2 = this.prototypicalCellSize.width;
        this.prototypicalCellSize.width = n;
        this.firePropertyChange("cellWidth", n2, n);
    }

    public int getCellWidth() {
        return this.prototypicalCellSize.width;
    }

    public Dimension getPreferredSize() {
        this.preferredSize.setSize(this.alignment.getLength() * this.getCellWidth(), this.alignment.getNumberSequences() * this.getCellHeight());
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setColorMap(ColorMap colorMap) {
        if (colorMap == null) {
            colorMap = new SingleColorMap(this.getBackground());
        }
        ColorMap colorMap2 = this.colorMap;
        this.colorMap = colorMap;
        this.firePropertyChange("colorMap", colorMap2, colorMap);
        this.repaint();
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setCursorModel(SequenceCursor sequenceCursor) {
        SequenceCursor sequenceCursor2 = this.cursor;
        this.cursor = sequenceCursor;
        this.firePropertyChange("sequenceCursor", sequenceCursor2, sequenceCursor);
    }

    public SequenceCursor getCursorModel() {
        return this.cursor;
    }

    public void addCursorChangeListener(ChangeListener changeListener) {
        this.cursor.addChangeListener(changeListener);
    }

    public void removeCursorChangeListener(ChangeListener changeListener) {
        this.cursor.removeChangeListener(changeListener);
    }

    public void setPoint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        if (sequenceAlignmentPoint.getX() < 1 || sequenceAlignmentPoint.getY() < 1 || sequenceAlignmentPoint.getX() > this.alignment.getLength() || sequenceAlignmentPoint.getY() > this.alignment.getNumberSequences()) {
            return;
        }
        SequenceAlignmentPoint sequenceAlignmentPoint2 = this.cursor.getPoint();
        this.cursor.setPoint(sequenceAlignmentPoint);
        this.ensureSequencePointIsVisible(sequenceAlignmentPoint);
        this.repaint(this.getCellBounds(sequenceAlignmentPoint2));
        this.repaint(this.getCellBounds(sequenceAlignmentPoint));
    }

    public void setMark() {
        this.cursor.setMark();
    }

    public void moveCursor(SequenceAlignmentPoint sequenceAlignmentPoint) {
        SequenceAlignmentPoint sequenceAlignmentPoint2 = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint2.move(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY()));
    }

    public void moveCursorUp(int n) {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY() - n));
    }

    public void moveCursorDown(int n) {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY() + n));
    }

    public void moveCursorPageUp() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        if (sequenceAlignmentPoint.getY() - (this.getVisibleSequenceRectangle().getSize().getHeight() - 2) < 1) {
            this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), 1));
        } else {
            this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY() - (this.getVisibleSequenceRectangle().getSize().getHeight() - 2)));
        }
    }

    public void moveCursorPageDown() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        if (sequenceAlignmentPoint.getY() + (this.getVisibleSequenceRectangle().getSize().getHeight() - 2) < 1) {
            this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), this.alignment.getNumberSequences()));
        } else {
            this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY() + (this.getVisibleSequenceRectangle().getSize().getHeight() - 2)));
        }
    }

    public void moveCursorBeginningOfAlignment() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(1, 1));
    }

    public void moveCursorEndOfAlignment() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(this.alignment.getSequenceAt(this.alignment.getNumberSequences()).getGappedLength(), this.alignment.getNumberSequences()));
    }

    public void moveCursorRight(int n) {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX() + n, sequenceAlignmentPoint.getY()));
    }

    public void moveCursorLeft(int n) {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX() - n, sequenceAlignmentPoint.getY()));
    }

    public void moveCursorPageRight() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX() + (this.getVisibleSequenceRectangle().getSize().getWidth() - 2), sequenceAlignmentPoint.getY()));
    }

    public void moveCursorPageLeft() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(sequenceAlignmentPoint.getX() - (this.getVisibleSequenceRectangle().getSize().getWidth() - 2), sequenceAlignmentPoint.getY()));
    }

    public void moveCursorBeginningOfSequence() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(1, sequenceAlignmentPoint.getY()));
    }

    public void moveCursorEndOfSequence() {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(this.alignment.getSequenceAt(sequenceAlignmentPoint.getY()).getGappedLength() + this.alignment.getInset(sequenceAlignmentPoint.getY()), sequenceAlignmentPoint.getY()));
    }

    public void moveCursorToSequencePoint(int n, int n2) {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursor.getPoint();
        this.setPoint(sequenceAlignmentPoint.move(n, n2));
        this.ensureSequencePointIsVisible(sequenceAlignmentPoint);
    }

    public void moveCursorToSequencePoint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.moveCursorToSequencePoint(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
    }

    public SequenceAlignmentPoint getPoint() {
        return this.cursor.getPoint();
    }

    public SequenceAlignmentPoint getMark() {
        return this.cursor.getMark();
    }

    public SequenceAlignmentPoint getSequencePointAtPoint(int n, int n2) {
        return this.viewerUI.getSequencePointAtPoint(n, n2);
    }

    public SequenceAlignmentPoint getSequencePointAtPoint(Point point) {
        return this.getSequencePointAtPoint(point.x, point.y);
    }

    public Point getPointAtSequencePoint(int n, int n2) {
        return this.viewerUI.getPointAtSequencePoint(n, n2);
    }

    public Rectangle getRectangleForSequenceRectangle(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        if (this.cacheRect == null) {
            this.cacheRect = new Rectangle();
        }
        this.cacheRect.setLocation(this.getPointAtSequencePoint(sequenceAlignmentRectangle.getX(), sequenceAlignmentRectangle.getY()));
        this.cacheRect.setSize(sequenceAlignmentRectangle.getWidth() * this.getCellWidth(), sequenceAlignmentRectangle.getHeight() * this.getCellHeight());
        return this.cacheRect;
    }

    public Rectangle getCellBounds(SequenceAlignmentPoint sequenceAlignmentPoint) {
        return this.viewerUI.getCellBounds(sequenceAlignmentPoint);
    }

    public void ensureSequencePointIsVisible(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.scrollRectToVisible(this.getCellBounds(sequenceAlignmentPoint));
    }

    public void setReadonly(boolean bl) {
        if (this.readonly != bl) {
            this.readonly = bl;
            this.firePropertyChange("readonly", !bl, bl);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void insertGapsAt(SequenceAlignmentPoint sequenceAlignmentPoint, int n) throws SequenceVetoException, AlignmentVetoException, ReadonlyException {
        if (this.isReadonly()) {
            throw new ReadonlyException(this);
        }
        if (sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()) > this.alignment.getSequenceAt(sequenceAlignmentPoint.getY()).getGappedLength()) {
            return;
        }
        if (sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()) > 1) {
            this.alignment.getSequenceAt(sequenceAlignmentPoint.getY()).insertGapAt(sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()), n);
        } else {
            this.alignment.setInset(sequenceAlignmentPoint.getY(), this.alignment.getInset(sequenceAlignmentPoint.getY()) + n);
        }
    }

    public void insertGapsAt(int n, int n2, int n3) throws SequenceVetoException, AlignmentVetoException, ReadonlyException {
        this.insertGapsAt(new SequenceAlignmentPoint(n, n2), n3);
    }

    public void deleteGapsAt(SequenceAlignmentPoint sequenceAlignmentPoint, int n) throws NoGapAtThisPositionException, SequenceVetoException, AlignmentVetoException, ReadonlyException {
        if (this.isReadonly()) {
            throw new ReadonlyException(this);
        }
        if (sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()) > this.alignment.getSequenceAt(sequenceAlignmentPoint.getY()).getGappedLength()) {
            return;
        }
        if (sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()) > 0) {
            this.alignment.getSequenceAt(sequenceAlignmentPoint.getY()).deleteGapAt(sequenceAlignmentPoint.getX() - this.alignment.getInset(sequenceAlignmentPoint.getY()), n);
        } else {
            this.alignment.setInset(sequenceAlignmentPoint.getY(), this.alignment.getInset(sequenceAlignmentPoint.getY()) - n);
        }
        Point point = this.getPointAtSequencePoint(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
        Rectangle rectangle = this.getBounds();
    }

    public void deleteGapsAt(int n, int n2, int n3) throws NoGapAtThisPositionException, SequenceVetoException, AlignmentVetoException, ReadonlyException {
        this.deleteGapsAt(new SequenceAlignmentPoint(n, n2), n3);
    }

    public void insertGapsAtCursor(int n) throws SequenceVetoException, AlignmentVetoException, ReadonlyException {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.getPoint();
        this.insertGapsAt(sequenceAlignmentPoint, n);
        this.moveCursorRight(n);
    }

    public void deleteGapsAtCursor(int n) throws NoGapAtThisPositionException, SequenceVetoException, AlignmentVetoException, ReadonlyException {
        SequenceAlignmentPoint sequenceAlignmentPoint = this.getPoint();
        this.deleteGapsAt(sequenceAlignmentPoint, n);
    }

    public SequenceAlignmentRectangle getVisibleSequenceRectangle() {
        Rectangle rectangle = this.getVisibleRect();
        SequenceAlignmentRectangle sequenceAlignmentRectangle = new SequenceAlignmentRectangle();
        sequenceAlignmentRectangle.setLocation(this.getSequencePointAtPoint(rectangle.x, rectangle.y));
        sequenceAlignmentRectangle.add(this.getSequencePointAtPoint(rectangle.x + rectangle.height, rectangle.y + rectangle.width));
        return sequenceAlignmentRectangle;
    }

    public AlignmentSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(AlignmentSelectionModel alignmentSelectionModel) {
        AlignmentSelectionModel alignmentSelectionModel2 = this.selectionModel;
        this.selectionModel = alignmentSelectionModel;
        alignmentSelectionModel2.removeAlignmentSelectionListener(this);
        alignmentSelectionModel.addAlignmentSelectionListener(this);
        this.firePropertyChange("alignmentSelectionModel", alignmentSelectionModel2, alignmentSelectionModel);
        this.repaint();
    }

    public void extendSelection(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.selectionModel.extendSelection(sequenceAlignmentPoint);
    }

    public void stopSelection(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.selectionModel.stopSelection(sequenceAlignmentPoint);
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSequenceAlignment(SequenceAlignment sequenceAlignment) {
        SequenceAlignment sequenceAlignment2 = this.alignment;
        this.alignment = sequenceAlignment;
        this.alignment.addSequenceListener((SequenceListener)this);
        this.alignment.addAlignmentListener((AlignmentListener)this);
        sequenceAlignment2.removeSequenceListener((SequenceListener)this);
        sequenceAlignment2.removeAlignmentListener((AlignmentListener)this);
        this.setPoint(new SequenceAlignmentPoint());
        this.setMark();
        this.clearSelection();
        this.firePropertyChange("sequenceAlignment", sequenceAlignment2, this.alignment);
        this.invalidate();
        this.repaint();
    }

    public SequenceAlignment getSequenceAlignment() {
        return this.alignment;
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        this.repaint();
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        this.viewerRect = this.getBounds(this.viewerRect);
        GappedSequence gappedSequence = (GappedSequence)sequenceEvent.getSource();
        Point point = this.getPointAtSequencePoint(sequenceEvent.getStart() - sequenceEvent.getLength(), this.alignment.getSequenceIndex(gappedSequence));
        if (this.viewerRect.contains(point)) {
            this.repaint(new Rectangle(point.x, point.y, this.viewerRect.width - point.x, this.getCellHeight()));
        }
    }

    public void valueChanged(AlignmentSelectionEvent alignmentSelectionEvent) {
        if (alignmentSelectionEvent.getSelectionRectangle() != null) {
            if (this.previousSelection != null) {
                this.repaint(this.getRectangleForSequenceRectangle(this.previousSelection));
            }
            this.previousSelection = new SequenceAlignmentRectangle(alignmentSelectionEvent.getSelectionRectangle());
            this.repaint(this.getRectangleForSequenceRectangle(this.previousSelection));
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0 && n2 > 0) {
            SequenceAlignmentPoint sequenceAlignmentPoint = this.getSequencePointAtPoint(rectangle.x, rectangle.y);
            Rectangle rectangle2 = this.getCellBounds(sequenceAlignmentPoint);
            int n3 = rectangle.x - rectangle2.x;
            return n3;
        }
        return 0;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 0;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(AlignmentViewerUI alignmentViewerUI) {
        super.setUI(alignmentViewerUI);
        this.viewerUI = alignmentViewerUI;
    }

    public void updateUI() {
        this.setUI((AlignmentViewerUI)UIManager.getUI(this));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$uk$ac$man$bioinf$gui$viewer$Install == null ? (class$uk$ac$man$bioinf$gui$viewer$Install = JAlignmentViewer.class$("uk.ac.man.bioinf.gui.viewer.Install")) : class$uk$ac$man$bioinf$gui$viewer$Install;
    }
}

