/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.util.forms;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.man.bioinf.gui.util.forms.DecimalField;
import uk.ac.man.bioinf.gui.util.forms.IntegerField;

public class ValidatedForm
extends JPanel {
    private HashMap labels = new HashMap();
    private HashMap fields = new HashMap();
    private HashMap modifiers = new HashMap();
    private HashMap changes = new HashMap();
    private GridBagConstraints c;
    private GridBagLayout gridbag;
    private int currentRow;
    private MyDocumentListener myDocumentListener = new MyDocumentListener();
    public static final int LESS_THAN = 0;
    public static final int GREATER_THAN = 1;
    public static final int EQUALS = 2;
    public static final int LIKE = 3;

    public ValidatedForm() {
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.c = new GridBagConstraints();
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.currentRow = 0;
        this.c.anchor = 13;
    }

    public void addIntegerField(String string, String string2, int n, boolean bl, int n2) {
        JLabel jLabel = new JLabel(string2);
        this.labels.put(string, jLabel);
        IntegerField integerField = new IntegerField(n, n2);
        this.fields.put(string, integerField);
        integerField.getDocument().addDocumentListener(this.myDocumentListener);
        integerField.getDocument().putProperty("name", string);
        ModifierCombo modifierCombo = new ModifierCombo(false);
        if (bl) {
            this.modifiers.put(string, modifierCombo);
        }
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = this.currentRow;
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(jLabel, this.c);
        this.add(jLabel);
        this.c.gridwidth = 1;
        this.c.gridx = 1;
        this.c.gridy = this.currentRow;
        this.c.fill = 2;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(modifierCombo, this.c);
        this.add(modifierCombo);
        this.c.gridwidth = 1;
        this.c.gridx = 2;
        this.c.gridy = this.currentRow++;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.gridbag.setConstraints(integerField, this.c);
        this.add(integerField);
        this.revalidate();
    }

    public void addIntegerField(String string, String string2, boolean bl, int n) {
        JLabel jLabel = new JLabel(string2);
        this.labels.put(string, jLabel);
        IntegerField integerField = new IntegerField(n);
        this.fields.put(string, integerField);
        integerField.getDocument().addDocumentListener(this.myDocumentListener);
        integerField.getDocument().putProperty("name", string);
        ModifierCombo modifierCombo = new ModifierCombo(false);
        if (bl) {
            this.modifiers.put(string, modifierCombo);
        }
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = this.currentRow;
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(jLabel, this.c);
        this.add(jLabel);
        this.c.gridwidth = 1;
        this.c.gridx = 1;
        this.c.gridy = this.currentRow;
        this.c.fill = 2;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(modifierCombo, this.c);
        this.add(modifierCombo);
        this.c.gridwidth = 1;
        this.c.gridx = 2;
        this.c.gridy = this.currentRow++;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.gridbag.setConstraints(integerField, this.c);
        this.add(integerField);
        this.revalidate();
    }

    public void addDecimalField(String string, String string2, double d, boolean bl, int n, boolean bl2) {
        DecimalField decimalField;
        Serializable serializable;
        JLabel jLabel = new JLabel(string2);
        this.labels.put(string, jLabel);
        if (bl2) {
            serializable = NumberFormat.getNumberInstance();
            serializable.setMinimumFractionDigits(3);
            ((DecimalFormat)serializable).setPositiveSuffix(" ");
            decimalField = new DecimalField(d, n, (NumberFormat)serializable);
        } else {
            serializable = NumberFormat.getNumberInstance();
            decimalField = new DecimalField(d, n, (NumberFormat)serializable);
        }
        this.fields.put(string, decimalField);
        decimalField.getDocument().addDocumentListener(this.myDocumentListener);
        decimalField.getDocument().putProperty("name", string);
        serializable = new ModifierCombo(false);
        if (bl) {
            this.modifiers.put(string, serializable);
        }
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = this.currentRow;
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(jLabel, this.c);
        this.add(jLabel);
        this.c.gridwidth = 1;
        this.c.gridx = 1;
        this.c.gridy = this.currentRow;
        this.c.fill = 2;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints((Component)serializable, this.c);
        this.add((Component)serializable);
        this.c.gridwidth = 1;
        this.c.gridx = 2;
        this.c.gridy = this.currentRow++;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.gridbag.setConstraints(decimalField, this.c);
        this.add(decimalField);
        this.revalidate();
    }

    public void addDecimalField(String string, String string2, boolean bl, int n, boolean bl2) {
        DecimalField decimalField;
        Serializable serializable;
        JLabel jLabel = new JLabel(string2);
        this.labels.put(string, jLabel);
        if (bl2) {
            serializable = NumberFormat.getNumberInstance();
            serializable.setMinimumFractionDigits(3);
            ((DecimalFormat)serializable).setPositiveSuffix(" ");
            decimalField = new DecimalField(n, (NumberFormat)serializable);
        } else {
            serializable = NumberFormat.getNumberInstance();
            decimalField = new DecimalField(n, (NumberFormat)serializable);
        }
        this.fields.put(string, decimalField);
        decimalField.getDocument().addDocumentListener(this.myDocumentListener);
        decimalField.getDocument().putProperty("name", string);
        serializable = new ModifierCombo(false);
        if (bl) {
            this.modifiers.put(string, serializable);
        }
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = this.currentRow;
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(jLabel, this.c);
        this.add(jLabel);
        this.c.gridwidth = 1;
        this.c.gridx = 1;
        this.c.gridy = this.currentRow;
        this.c.fill = 2;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints((Component)serializable, this.c);
        this.add((Component)serializable);
        this.c.gridwidth = 1;
        this.c.gridx = 2;
        this.c.gridy = this.currentRow++;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.gridbag.setConstraints(decimalField, this.c);
        this.add(decimalField);
        this.revalidate();
    }

    public void addTextField(String string, String string2, String string3, boolean bl, int n) {
        JLabel jLabel = new JLabel(string2);
        this.labels.put(string, jLabel);
        JTextField jTextField = new JTextField(string3, n);
        this.fields.put(string, jTextField);
        jTextField.getDocument().addDocumentListener(this.myDocumentListener);
        jTextField.getDocument().putProperty("name", string);
        ModifierCombo modifierCombo = new ModifierCombo(true);
        if (bl) {
            this.modifiers.put(string, modifierCombo);
        }
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = this.currentRow;
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(jLabel, this.c);
        this.add(jLabel);
        this.c.gridwidth = 1;
        this.c.gridx = 1;
        this.c.gridy = this.currentRow;
        this.c.fill = 2;
        this.c.weightx = 0.0;
        this.gridbag.setConstraints(modifierCombo, this.c);
        this.add(modifierCombo);
        this.c.gridwidth = 1;
        this.c.gridx = 2;
        this.c.gridy = this.currentRow++;
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.gridbag.setConstraints(jTextField, this.c);
        this.add(jTextField);
        this.revalidate();
    }

    public int getIntegerFieldValue(String string) {
        IntegerField integerField = (IntegerField)this.fields.get(string);
        return integerField.getValue();
    }

    public double getDecimalFieldValue(String string) {
        DecimalField decimalField = (DecimalField)this.fields.get(string);
        return decimalField.getValue();
    }

    public String getTextFieldValue(String string) {
        JTextField jTextField = (JTextField)this.fields.get(string);
        return jTextField.getText();
    }

    public boolean isIntegerFieldValid(String string) {
        IntegerField integerField = (IntegerField)this.fields.get(string);
        return integerField.isValid();
    }

    public boolean isDecimalFieldValid(String string) {
        DecimalField decimalField = (DecimalField)this.fields.get(string);
        return decimalField.isValid();
    }

    public boolean isTextFieldValid(String string) {
        JTextField jTextField = (JTextField)this.fields.get(string);
        return !jTextField.getText().equals("");
    }

    public void setIntegerFieldValue(String string, int n) {
        IntegerField integerField = (IntegerField)this.fields.get(string);
        integerField.setValue(n);
    }

    public void setDecimalFieldValue(String string, double d) {
        DecimalField decimalField = (DecimalField)this.fields.get(string);
        decimalField.setValue(d);
    }

    public void setTextFieldValue(String string, String string2) {
        JTextField jTextField = (JTextField)this.fields.get(string);
        jTextField.setText(string2);
    }

    public int getModifierType(String string) {
        ModifierCombo modifierCombo = (ModifierCombo)this.modifiers.get(string);
        String string2 = (String)modifierCombo.getSelectedItem();
        if (string2.equals("<")) {
            return 0;
        }
        if (string2.equals(">")) {
            return 1;
        }
        if (string2.equals("=")) {
            return 2;
        }
        if (string2.equals("equals")) {
            return 2;
        }
        return 3;
    }

    public void setModifierType(String string, int n) {
        ModifierCombo modifierCombo = (ModifierCombo)this.modifiers.get(string);
        switch (n) {
            case 0: {
                modifierCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                modifierCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                modifierCombo.setSelectedIndex(2);
                break;
            }
            case 3: {
                modifierCombo.setSelectedIndex(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Modifier type out of range!");
            }
        }
    }

    private class ModifierCombo
    extends JComboBox {
        public ModifierCombo(boolean bl) {
            if (bl) {
                this.initText();
            } else {
                this.initNumber();
            }
        }

        private void initText() {
            this.addItem("equals");
            this.addItem("like");
        }

        private void initNumber() {
            this.addItem("=");
            this.addItem("<");
            this.addItem(">");
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.recordChange(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.recordChange(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void recordChange(DocumentEvent documentEvent) {
        }
    }
}

