/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.optionable;

import javax.swing.JSplitPane;
import uk.ac.man.bioinf.apps.optionable.NullOptionHandler;
import uk.ac.man.bioinf.apps.optionable.OptionHandler;
import uk.ac.man.bioinf.apps.optionable.Optionable;
import uk.ac.man.bioinf.apps.optionable.OptionableStateException;

public class OptionableJSplitPane
extends JSplitPane
implements Optionable {
    private String optionableName;
    private OptionHandler optionHandler;
    private boolean locationSetAsOption = false;
    private boolean haveOptioned;
    private static OptionHandler defaultOptionHandler;

    public OptionableJSplitPane(String string) {
        this.optionableName = string;
        this.forceOptionable();
    }

    public OptionableJSplitPane(String string, int n) {
        super(n);
        this.optionableName = string;
        this.forceOptionable();
    }

    public void setDefaultDividerLocation(int n) {
        if (!this.locationSetAsOption) {
            super.setDividerLocation(n);
        }
    }

    public void setOptions() throws OptionableStateException {
        if (this.haveOptioned) {
            throw new OptionableStateException("Have already set the optionable status of this frame");
        }
        this.forceOptionable();
    }

    protected void forceOptionable() {
        if (this.haveOptioned) {
            throw new RuntimeException("Have already set the optionable status of this frame");
        }
        this.getOptionHandler().addOptionable((Optionable)this);
        this.haveOptioned = true;
    }

    public Object getOptions() {
        return new Integer(this.getDividerLocation());
    }

    public void setOptions(Object object) {
        try {
            if (object != null) {
                this.setDividerLocation((Integer)object);
                this.locationSetAsOption = true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void setOptionHandler(OptionHandler optionHandler) {
        this.optionHandler = optionHandler;
    }

    public OptionHandler getOptionHandler() {
        if (this.optionHandler == null) {
            return OptionableJSplitPane.getDefaultOptionHandler();
        }
        return this.optionHandler;
    }

    public String getOptionGroupName() {
        return this.optionableName;
    }

    public static void setDefaultOptionHandler(OptionHandler optionHandler) {
        defaultOptionHandler = optionHandler;
    }

    public static OptionHandler getDefaultOptionHandler() {
        if (defaultOptionHandler == null) {
            return NullOptionHandler.getInstance();
        }
        return defaultOptionHandler;
    }
}

