/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.misc;

import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;

public class SwappingListBasicUI
extends BasicListUI {
    protected MouseInputListener createMouseInputListener() {
        return new SwappingMouseInputHandler();
    }

    protected int convertYToRow(int n) {
        return super.convertYToRow(n);
    }

    protected JList getJList() {
        return this.list;
    }

    public class SwappingMouseInputHandler
    extends BasicListUI.MouseInputHandler {
        private int indexOfElementBeingDragged = -1;

        public SwappingMouseInputHandler() {
            super(SwappingListBasicUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = SwappingListBasicUI.this.convertYToRow(mouseEvent.getY());
                if (n != -1) {
                    this.indexOfElementBeingDragged = n;
                }
            } else {
                this.indexOfElementBeingDragged = -1;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n = SwappingListBasicUI.this.convertYToRow(mouseEvent.getY())) != -1 && n != this.indexOfElementBeingDragged) {
                int n2 = Math.max(n, this.indexOfElementBeingDragged);
                int n3 = Math.min(n, this.indexOfElementBeingDragged);
                this.swap(n2, n3);
                this.indexOfElementBeingDragged = n;
            }
        }

        protected void swap(int n, int n2) {
            JList jList = SwappingListBasicUI.this.getJList();
            DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            Object e = defaultListModel.remove(n);
            Object e2 = defaultListModel.getElementAt(n2);
            defaultListModel.insertElementAt(e2, n);
            defaultListModel.remove(n2);
            defaultListModel.insertElementAt(e, n2);
        }
    }
}

