/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.color;

import java.awt.Color;
import java.util.HashMap;
import uk.ac.man.bioinf.gui.color.ColorMap;
import uk.ac.man.bioinf.gui.color.ColorMapException;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;

public class IndividualElementColorMap
implements ColorMap {
    private String name;
    private HashMap mapping = new HashMap();

    public IndividualElementColorMap(String string, Element[] elementArray, Color[] colorArray) {
        this.name = string;
        if (elementArray.length != colorArray.length) {
            throw new ColorMapException("The number of elements and colors supplied are not the same");
        }
        int n = 0;
        while (n < elementArray.length) {
            this.mapping.put(elementArray[n], colorArray[n]);
            ++n;
        }
    }

    public Color getColorAt(SequenceAlignment sequenceAlignment, Element element, SequenceAlignmentPoint sequenceAlignmentPoint) {
        if (element == null) {
            return null;
        }
        return (Color)this.mapping.get(element);
    }

    public String getName() {
        return this.name;
    }
}

