/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.color;

import java.awt.Color;
import uk.ac.man.bioinf.gui.color.ColorList;
import uk.ac.man.bioinf.gui.color.ColorMap;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;

public class DoubleArrayColorMap
implements ColorMap {
    private int[][] colourAtPosition;
    private double[][] array;
    private ColorList colors;

    public DoubleArrayColorMap(double[][] dArray, ColorList colorList) {
        this.array = dArray;
        this.colors = colorList;
    }

    public Color getColorAt(SequenceAlignment sequenceAlignment, Element element, SequenceAlignmentPoint sequenceAlignmentPoint) {
        try {
            if (element == Gap.gap) {
                return Color.white;
            }
            if (element == null) {
                return Color.white;
            }
            int n = sequenceAlignmentPoint.getY() - 1;
            if (sequenceAlignmentPoint.getX() - sequenceAlignment.getInset(n + 1) < 1) {
                return Color.white;
            }
            int n2 = sequenceAlignment.getSequenceAt(n + 1).getUngappedPositionOf(sequenceAlignmentPoint.getX() - sequenceAlignment.getInset(n + 1)) - 1;
            if (n2 < 0) {
                return Color.white;
            }
            return this.colors.getColorAt((int)(this.array[n][n2] * (double)(this.colors.length() - 1)));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException.getMessage());
            return Color.green;
        }
    }

    public String getName() {
        return "DoubleArrayColorMap";
    }
}

