/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.group;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoSuchSequenceException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEventType;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListenerSupport;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentVetoException;
import uk.ac.man.bioinf.sequence.alignment.event.VetoableAlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.VetoableAlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceListenerSupport;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;
import uk.ac.man.bioinf.sequence.group.AbstractGappedSequenceGroup;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.util.IntArrayList;

public class GroupSequenceAlignment
extends AbstractGappedSequenceGroup
implements SequenceAlignment,
AlignmentListener {
    private SequenceAlignment alignment;
    private IntArrayList seqArray = new IntArrayList();
    private int changeNumber = 0;
    private AlignmentListenerSupport alignSupp = new AlignmentListenerSupport();
    private SequenceListenerSupport seqSupp = new SequenceListenerSupport();

    public GroupSequenceAlignment(SequenceAlignment sequenceAlignment) {
        this.alignment = sequenceAlignment;
        sequenceAlignment.addAlignmentListener(this);
        sequenceAlignment.addSequenceListener(this);
    }

    public GroupSequenceAlignment(SequenceAlignment sequenceAlignment, IntArrayList intArrayList) {
        this(sequenceAlignment);
        int n = sequenceAlignment.getNumberSequences();
        int n2 = 0;
        while (n2 < intArrayList.size()) {
            int n3 = intArrayList.get(n2);
            if (n3 < 1 || n3 > n) {
                throw new IllegalArgumentException("The value " + n3 + " at position " + n2 + " is outside the allowable range");
            }
            ++n2;
        }
    }

    public Sequence[] getSequences() {
        Sequence[] sequenceArray = new Sequence[this.seqArray.size()];
        int n = 0;
        while (n < sequenceArray.length) {
            sequenceArray[n] = this.alignment.getSequenceAt(this.seqArray.get(n));
            ++n;
        }
        return sequenceArray;
    }

    public void addSequenceToGroup(Sequence sequence) {
        try {
            this.alignSupp.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, this.seqArray.size(), AlignmentEventType.INSERT));
        }
        catch (AlignmentVetoException alignmentVetoException) {
            // empty catch block
        }
        int n = this.alignment.getSequenceIndex((GappedSequence)sequence);
        if (n == -1) {
            throw new IllegalArgumentException("The sequence must be a member of the associated sequence alignment");
        }
        this.seqArray.add(n);
        this.alignSupp.fireAlignmentEvent(new AlignmentEvent(this, this.seqArray.size(), AlignmentEventType.INSERT));
        ++this.changeNumber;
    }

    public void addSequence(GappedSequence gappedSequence, int n) throws AlignmentVetoException {
    }

    public int getLength() {
        return this.alignment.getLength();
    }

    public void removeSequenceFromGroup(Sequence sequence) {
        int n = this.alignment.getSequenceIndex((GappedSequence)sequence);
        if (n != -1) {
            try {
                this.alignSupp.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, n, AlignmentEventType.DELETE));
            }
            catch (AlignmentVetoException alignmentVetoException) {
                // empty catch block
            }
            this.seqArray.remove(this.seqArray.linearSearch(n));
            ++this.changeNumber;
            this.alignSupp.fireAlignmentEvent(new AlignmentEvent(this, n, AlignmentEventType.DELETE));
        }
    }

    public GappedSequence removeSequence(int n) throws AlignmentVetoException {
        return null;
    }

    public void setInset(int n, int n2) throws AlignmentVetoException {
    }

    public void clearSequences() {
        try {
            this.alignSupp.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, 1, this.seqArray.size(), AlignmentEventType.DELETE));
        }
        catch (AlignmentVetoException alignmentVetoException) {
            // empty catch block
        }
        this.seqArray.clear();
        ++this.changeNumber;
        this.alignSupp.fireAlignmentEvent(new AlignmentEvent(this, 1, this.seqArray.size(), AlignmentEventType.DELETE));
    }

    public int getNumberSequences() {
        return this.seqArray.size();
    }

    public boolean containsSequence(Sequence sequence) {
        int n = this.alignment.getSequenceIndex((GappedSequence)sequence);
        return this.seqArray.linearSearch(n) != -1;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int expectedChangeNumber;
            private int index;
            {
                this.expectedChangeNumber = GroupSequenceAlignment.this.changeNumber;
                this.index = 0;
            }

            public boolean hasNext() {
                if (this.expectedChangeNumber != GroupSequenceAlignment.this.changeNumber) {
                    throw new ConcurrentModificationException("GroupSequenceAlignment has been modified");
                }
                return this.index < GroupSequenceAlignment.this.getLength();
            }

            public Object next() {
                if (this.expectedChangeNumber != GroupSequenceAlignment.this.changeNumber) {
                    throw new ConcurrentModificationException("GroupSequenceAlignment has been modified");
                }
                return GroupSequenceAlignment.this.alignment.getSequenceAt(GroupSequenceAlignment.this.seqArray.get(this.index++));
            }

            public void remove() {
                throw new UnsupportedOperationException("GroupSequenceAlignment does not support the remove method");
            }
        };
    }

    public GappedSequence getSequenceAt(int n) {
        return this.alignment.getSequenceAt(this.seqArray.get(n - 1));
    }

    public SequenceAlignment getSubAlignment(int n, int n2, int n3, int n4) {
        throw new RuntimeException("Not implemented yet");
    }

    public SequenceAlignment getSubAlignment(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        return this.getSubAlignment(sequenceAlignmentRectangle.getX(), sequenceAlignmentRectangle.getWidth(), sequenceAlignmentRectangle.getY(), sequenceAlignmentRectangle.getHeight());
    }

    public SequenceType getSequenceType() {
        return this.alignment.getSequenceType();
    }

    public int getInset(int n) {
        try {
            return this.alignment.getInset(this.seqArray.get(n - 1));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchSequenceException(this, n);
        }
    }

    public int getSequenceIndex(GappedSequence gappedSequence) {
        return this.seqArray.linearSearch(this.alignment.getSequenceIndex(gappedSequence)) + 1;
    }

    public void removeAlignmentListener(AlignmentListener alignmentListener) {
        this.alignSupp.removeAlignmentListener(alignmentListener);
    }

    public void addAlignmentListener(AlignmentListener alignmentListener) {
        this.alignSupp.addAlignmentListener(alignmentListener);
    }

    public void removeVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
        this.alignSupp.removeVetoableAlignmentListener(vetoableAlignmentListener);
    }

    public void addVetoableAlignmentListener(VetoableAlignmentListener vetoableAlignmentListener) {
        this.alignSupp.addVetoableAlignmentListener(vetoableAlignmentListener);
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        if (this.containsSequence((Sequence)sequenceEvent.getSource())) {
            this.seqSupp.fireSequenceEvent(sequenceEvent);
        }
    }

    public void vetoableChangeOccurred(VetoableSequenceEvent vetoableSequenceEvent) throws SequenceVetoException {
        if (this.containsSequence((Sequence)vetoableSequenceEvent.getSource())) {
            this.seqSupp.fireVetoableSequenceEvent(vetoableSequenceEvent);
        }
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        this.alignSupp.fireAlignmentEvent(new AlignmentEvent(this, 1, this.getNumberSequences(), AlignmentEventType.UNSPECIFIED));
    }

    public void vetoableChangeOccurred(VetoableAlignmentEvent vetoableAlignmentEvent) throws AlignmentVetoException {
        this.alignSupp.fireVetoableAlignmentEvent(new VetoableAlignmentEvent(this, 1, this.getNumberSequences(), AlignmentEventType.UNSPECIFIED));
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
        this.seqSupp.addSequenceListener(sequenceListener);
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
        this.seqSupp.removeSequenceListener(sequenceListener);
    }

    public void addVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        this.seqSupp.addVetoableSequenceListener(vetoableSequenceListener);
    }

    public void removeVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        this.seqSupp.removeVetoableSequenceListener(vetoableSequenceListener);
    }

    public Identifier getIdentifier() {
        return this.alignment.getIdentifier();
    }
}

