/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.geom;

import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentDimension;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentShape;

public class SequenceAlignmentRectangle
implements SequenceAlignmentShape,
Comparable {
    private SequenceAlignmentPoint location;
    private SequenceAlignmentDimension size;

    public SequenceAlignmentRectangle() {
        this(1, 1, 1, 1);
    }

    public SequenceAlignmentRectangle(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public SequenceAlignmentRectangle(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        this.setBounds(sequenceAlignmentRectangle);
    }

    public SequenceAlignmentRectangle(int n, int n2, SequenceAlignmentDimension sequenceAlignmentDimension) {
        this.setBounds(n, n2, sequenceAlignmentDimension.getWidth(), sequenceAlignmentDimension.getHeight());
    }

    public SequenceAlignmentRectangle(SequenceAlignmentPoint sequenceAlignmentPoint, int n, int n2) {
        this.setBounds(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY(), n, n2);
    }

    public boolean contains(int n, int n2) {
        return n >= this.location.getX() && n2 >= this.location.getY() && n <= this.location.getX() + this.size.getWidth() - 1 && n2 <= this.location.getY() + this.size.getHeight() - 1;
    }

    public boolean contains(SequenceAlignmentPoint sequenceAlignmentPoint) {
        return this.contains(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
    }

    public boolean equals(Object object) {
        return object instanceof SequenceAlignmentRectangle && ((SequenceAlignmentRectangle)object).getLocation().equals(this.location) && ((SequenceAlignmentRectangle)object).getSize().equals(this.size);
    }

    public int compareTo(Object object) {
        SequenceAlignmentRectangle sequenceAlignmentRectangle = (SequenceAlignmentRectangle)object;
        if (this.equals(sequenceAlignmentRectangle)) {
            return 0;
        }
        int n = this.location.compareTo(sequenceAlignmentRectangle.location);
        if (n != 0) {
            return n;
        }
        if (this.size.getWidth() < sequenceAlignmentRectangle.size.getWidth()) {
            return -1;
        }
        if (this.size.getHeight() < sequenceAlignmentRectangle.size.getHeight()) {
            return -1;
        }
        return 1;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.location = new SequenceAlignmentPoint(n, n2);
        this.size = new SequenceAlignmentDimension(n3, n4);
    }

    public void setBounds(SequenceAlignmentPoint sequenceAlignmentPoint, SequenceAlignmentDimension sequenceAlignmentDimension) {
        this.setBounds(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY(), sequenceAlignmentDimension.getWidth(), sequenceAlignmentDimension.getHeight());
    }

    public void setBounds(SequenceAlignmentRectangle sequenceAlignmentRectangle) {
        this.setBounds(sequenceAlignmentRectangle.getLocation().getX(), sequenceAlignmentRectangle.getLocation().getY(), sequenceAlignmentRectangle.getSize().getWidth(), sequenceAlignmentRectangle.getSize().getHeight());
    }

    public SequenceAlignmentRectangle getBounds() {
        return new SequenceAlignmentRectangle(this);
    }

    public void setLocation(int n, int n2) {
        this.location = new SequenceAlignmentPoint(n, n2);
    }

    public void setLocation(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.setLocation(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
    }

    public SequenceAlignmentPoint getLocation() {
        return new SequenceAlignmentPoint(this.location);
    }

    public void setSize(int n, int n2) {
        this.size = new SequenceAlignmentDimension(n, n2);
    }

    public void setSize(SequenceAlignmentDimension sequenceAlignmentDimension) {
        this.setSize(sequenceAlignmentDimension.getWidth(), sequenceAlignmentDimension.getHeight());
    }

    public SequenceAlignmentDimension getSize() {
        return new SequenceAlignmentDimension(this.size);
    }

    public int getX() {
        return this.location.getX();
    }

    public int getY() {
        return this.location.getY();
    }

    public int getHeight() {
        return this.size.getHeight();
    }

    public int getWidth() {
        return this.size.getWidth();
    }

    public void add(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.add(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
    }

    public void add(int n, int n2) {
        int n3 = this.location.getX();
        int n4 = this.location.getY();
        int n5 = this.size.getWidth();
        int n6 = this.size.getHeight();
        int n7 = Math.min(n3, n);
        int n8 = Math.max(n3 + n5, n + 1);
        int n9 = Math.min(n4, n2);
        int n10 = Math.max(n4 + n6, n2 + 1);
        this.setLocation(n7, n9);
        this.setSize(n8 - n7, n10 - n9);
    }

    public String toString() {
        return super.toString() + " Location [" + this.location.getX() + "x" + this.location.getY() + "+" + this.size.getWidth() + "+" + this.size.getHeight() + "]";
    }
}

