/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.event;

import java.util.Enumeration;
import java.util.Vector;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;

public class SequenceListenerSupport {
    private Vector listeners = new Vector();
    private Vector vetoableListeners = new Vector();

    public boolean hasListeners() {
        return this.listeners.size() > 0 || this.vetoableListeners.size() > 0;
    }

    public void fireSequenceEvent(SequenceEvent sequenceEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SequenceListener)enumeration.nextElement()).changeOccurred(sequenceEvent);
        }
        Enumeration enumeration2 = this.vetoableListeners.elements();
        while (enumeration2.hasMoreElements()) {
            ((SequenceListener)enumeration2.nextElement()).changeOccurred(sequenceEvent);
        }
    }

    public void fireVetoableSequenceEvent(VetoableSequenceEvent vetoableSequenceEvent) throws SequenceVetoException {
        Enumeration enumeration = this.vetoableListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((VetoableSequenceListener)enumeration.nextElement()).vetoableChangeOccurred(vetoableSequenceEvent);
        }
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
        if (sequenceListener == null) {
            throw new NullPointerException("Can not add null sequence listener");
        }
        if (this.listeners.contains(sequenceListener)) {
            return;
        }
        this.listeners.addElement(sequenceListener);
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
        this.listeners.removeElement(sequenceListener);
    }

    public void addVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        if (vetoableSequenceListener == null) {
            throw new NullPointerException("Can not add null sequence listener");
        }
        if (this.vetoableListeners.contains(vetoableSequenceListener)) {
            return;
        }
        this.vetoableListeners.addElement(vetoableSequenceListener);
        this.addSequenceListener(vetoableSequenceListener);
    }

    public void removeVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
        this.vetoableListeners.removeElement(vetoableSequenceListener);
        this.removeSequenceListener(vetoableSequenceListener);
    }
}

