/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import java.util.HashMap;
import java.util.Map;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.DefaultComplexElement;
import uk.ac.man.bioinf.sequence.complex.Modification;

class HardComplexElementFactory {
    private DefaultComplexElement cachedElement;
    private Map complexElements = new HashMap();

    HardComplexElementFactory() {
    }

    public ComplexElement getComplexElement(Residue residue, Modification modification) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        this.cachedElement.setResidue(residue);
        this.cachedElement.setModifications(modification);
        return this.getCachedComplexElement();
    }

    public ComplexElement getComplexElement(ComplexElement complexElement, Modification modification) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        this.cachedElement.setResidue(complexElement.getResidue());
        this.cachedElement.setModifications(complexElement.getModifications(), modification);
        return this.getCachedComplexElement();
    }

    private ComplexElement getCachedComplexElement() {
        ComplexElement complexElement = (ComplexElement)this.complexElements.get(this.cachedElement);
        if (complexElement != null) {
            return complexElement;
        }
        this.complexElements.put(this.cachedElement, this.cachedElement);
        complexElement = this.cachedElement;
        this.cachedElement = null;
        return complexElement;
    }
}

