/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexSequenceType;
import uk.ac.man.bioinf.sequence.complex.Modification;

public class DefaultComplexSequenceType
implements ComplexSequenceType {
    private Modification[] mods;
    private SequenceType type;
    private String name;

    public DefaultComplexSequenceType(SequenceType sequenceType, Modification[] modificationArray, String string) {
        this.type = sequenceType;
        this.mods = modificationArray;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Modification[] getModifications() {
        return (Modification[])this.mods.clone();
    }

    public boolean isModification(Modification modification) {
        int n = 0;
        while (n < this.mods.length) {
            if (this.mods[n].equals(modification)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isModification(Modification[] modificationArray) {
        int n = 0;
        while (n < modificationArray.length) {
            if (!this.isModification(modificationArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isAllowableElement(ComplexElement complexElement) {
        return this.type.isElement(complexElement.getResidue()) && this.isModification(complexElement.getModifications());
    }

    public boolean isElement(Element[] elementArray) {
        return this.type.isElement(elementArray);
    }

    public boolean isElement(char[] cArray) {
        return this.type.isElement(cArray);
    }

    public boolean isElement(Element element) {
        return this.type.isElement(element);
    }

    public boolean isElement(char c) {
        return this.type.isElement(c);
    }

    public Element[] getElements() {
        return this.type.getElements();
    }

    public Element getElementForInt(int n) {
        return this.type.getElementForInt(n);
    }

    public int getIntForElement(Element element) {
        return this.type.getIntForElement(element);
    }

    public int size() {
        return this.type.size();
    }
}

