/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import java.util.Arrays;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexSequenceType;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.sequence.types.AbstractSequenceType;

public abstract class AbstractComplexSequenceType
extends AbstractSequenceType
implements ComplexSequenceType {
    private Modification[] modifications;

    public AbstractComplexSequenceType(Residue[] residueArray, Modification modification, String string) {
        super(residueArray, string);
        this.modifications = new Modification[1];
        this.modifications[0] = modification;
    }

    public AbstractComplexSequenceType(Residue[] residueArray, Modification[] modificationArray, String string) {
        super(residueArray, string);
        this.modifications = modificationArray;
        Arrays.sort(modificationArray);
    }

    public Modification[] getModifications() {
        Modification[] modificationArray = new Modification[this.modifications.length];
        System.arraycopy(this.modifications, 0, modificationArray, 0, this.modifications.length);
        return modificationArray;
    }

    public boolean isModification(Modification modification) {
        return Arrays.binarySearch(this.modifications, modification) > 0;
    }

    public boolean isModification(Modification[] modificationArray) {
        int n = 0;
        while (n < modificationArray.length) {
            if (this.isModification(modificationArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isAllowableElement(ComplexElement complexElement) {
        if (!this.isElement(complexElement.getResidue())) {
            return false;
        }
        return this.isModification(complexElement.getModifications());
    }
}

