/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.NoSuchSequenceElementException;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoGapAtThisPositionException;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;
import uk.ac.man.bioinf.sequence.types.EmptySequenceType;

public class EmptyGappedSequence
implements GappedSequence {
    private static final EmptyGappedSequence instance = new EmptyGappedSequence();
    private static Element[] noElements = new Element[0];
    private static char[] noChars = new char[0];
    private static Identifier ident = new NoIdentifier();

    public static EmptyGappedSequence getInstance() {
        return instance;
    }

    private EmptyGappedSequence() {
    }

    private NoSuchSequenceElementException createException() {
        return new NoSuchSequenceElementException("Empty Gapped Sequence does not do much");
    }

    public Sequence getSubSequence(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw this.createException();
        }
        return this;
    }

    public SequenceType getSequenceType() {
        return EmptySequenceType.getInstance();
    }

    public Element[] getSequenceAsElements() {
        return noElements;
    }

    public char[] getSequenceAsChars() {
        return noChars;
    }

    public int getLength() {
        return 0;
    }

    public char getElementAtAsChar(int n) {
        throw this.createException();
    }

    public Element getElementAt(int n) {
        throw this.createException();
    }

    public void insertGapAt(int n, int n2) throws NoSuchSequenceElementException, SequenceVetoException {
        throw this.createException();
    }

    public void insertGapAt(int n) throws NoSuchSequenceElementException, SequenceVetoException {
        throw this.createException();
    }

    public int getUngappedPositionOf(int n) {
        throw this.createException();
    }

    public GappedSequence getGappedSubSequence(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw this.createException();
        }
        return this;
    }

    public Element[] getGappedSequenceAsElements() {
        return noElements;
    }

    public char[] getGappedSequenceAsChars() {
        return noChars;
    }

    public int getGappedPositionOf(int n) {
        throw this.createException();
    }

    public int getGappedLength() {
        return 0;
    }

    public char getGappedElementAtAsChar(int n) {
        throw this.createException();
    }

    public Element getGappedElementAt(int n) {
        throw this.createException();
    }

    public void deleteGapAt(int n, int n2) throws NoGapAtThisPositionException, NoSuchSequenceElementException, SequenceVetoException {
        throw this.createException();
    }

    public void deleteGapAt(int n) throws NoGapAtThisPositionException, NoSuchSequenceElementException, SequenceVetoException {
        throw this.createException();
    }

    public Identifier getIdentifier() {
        return ident;
    }

    public void removeVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
    }

    public void addVetoableSequenceListener(VetoableSequenceListener vetoableSequenceListener) {
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
    }
}

