/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import java.util.ArrayList;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.NoSuchSequenceElementException;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.AbstractSequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.DefaultGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.EmptyGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoSuchSequenceException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;
import uk.ac.man.bioinf.util.IntArrayList;

public class DefaultSequenceAlignment
extends AbstractSequenceAlignment {
    private ArrayList msa;
    private Identifier ident;
    private SequenceType type;
    private int length;
    private IntArrayList inset;

    protected void init(GappedSequence[] gappedSequenceArray, SequenceType sequenceType, int[] nArray, Identifier identifier) {
        this.msa = new ArrayList();
        this.inset = new IntArrayList();
        this.type = sequenceType;
        this.ident = identifier;
        int n = 0;
        while (n < gappedSequenceArray.length) {
            this.msa.add(gappedSequenceArray[n]);
            this.inset.add(nArray[n]);
            ((GappedSequence)this.msa.get(n)).addSequenceListener(this);
            if (((GappedSequence)this.msa.get(n)).getGappedLength() + this.inset.get(n) > this.length) {
                this.length = ((GappedSequence)this.msa.get(n)).getGappedLength() + this.inset.get(n);
            }
            ++n;
        }
    }

    public DefaultSequenceAlignment(SequenceType sequenceType) {
        this.init(new GappedSequence[0], sequenceType, new int[0], new NoIdentifier());
    }

    public DefaultSequenceAlignment(SequenceType sequenceType, Identifier identifier) {
        this.init(new GappedSequence[0], sequenceType, new int[0], identifier);
    }

    public DefaultSequenceAlignment(Element[][] elementArray, SequenceType sequenceType) {
        GappedSequence[] gappedSequenceArray = new GappedSequence[elementArray.length];
        int n = 0;
        while (n < elementArray.length) {
            gappedSequenceArray[n] = new DefaultGappedSequence(elementArray[n], sequenceType);
            gappedSequenceArray[n].addSequenceListener(this);
            ++n;
        }
        this.init(gappedSequenceArray, sequenceType, new int[gappedSequenceArray.length], new NoIdentifier());
    }

    public DefaultSequenceAlignment(GappedSequence[] gappedSequenceArray, SequenceType sequenceType, int[] nArray, Identifier identifier) {
        this.init(gappedSequenceArray, sequenceType, nArray, identifier);
    }

    public DefaultSequenceAlignment(GappedSequence[] gappedSequenceArray, SequenceType sequenceType, int[] nArray) {
        this.init(gappedSequenceArray, sequenceType, nArray, new NoIdentifier());
    }

    public DefaultSequenceAlignment(GappedSequence[] gappedSequenceArray, SequenceType sequenceType) {
        this.init(gappedSequenceArray, sequenceType, new int[gappedSequenceArray.length], new NoIdentifier());
    }

    public DefaultSequenceAlignment(SequenceAlignment sequenceAlignment, SequenceType sequenceType) {
        GappedSequence[] gappedSequenceArray = new GappedSequence[sequenceAlignment.getNumberSequences()];
        int[] nArray = new int[sequenceAlignment.getNumberSequences()];
        int n = 0;
        while (n < sequenceAlignment.getNumberSequences()) {
            gappedSequenceArray[n] = Sequences.getElementsAsGappedSequence(sequenceAlignment.getSequenceAt(n).getGappedSequenceAsElements(), sequenceType);
            nArray[n] = sequenceAlignment.getInset(n);
            gappedSequenceArray[n].addSequenceListener(this);
            ++n;
        }
        this.init(gappedSequenceArray, sequenceType, nArray, new NoIdentifier());
    }

    public SequenceAlignment getSubAlignment(int n, int n2, int n3, int n4) {
        if (n < 1) {
            throw new NoSuchSequenceElementException("Attempt to access element at zero or negative index. Sequences start at index 1");
        }
        if (n + n2 > this.getLength()) {
            throw new NoSuchSequenceElementException("Attempt to access element greater than sequence alignment length");
        }
        if (n3 < 1) {
            throw new NoSuchSequenceException("Attempt to access a sequence at zero or negative index. Indexing starts at 1");
        }
        if (n3 - 1 + n4 > this.msa.size()) {
            throw new NoSuchSequenceException("Attempt to access a sequence with an index greater than the alignment length");
        }
        GappedSequence[] gappedSequenceArray = new GappedSequence[n4];
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = n3;
        while (n6 < n3 + n4) {
            if (this.getInset(n6) > n + n2 || this.getInset(n6) + this.getSequenceAt(n6).getLength() < n) {
                nArray[n5] = n + n2;
                gappedSequenceArray[n5++] = EmptyGappedSequence.getInstance();
            } else {
                nArray[n5] = this.getInset(n6) - n + 1;
                nArray[n5] = Math.max(nArray[n5], 0);
                int n7 = Math.max(1, n - this.getInset(n6));
                int n8 = Math.min(this.getSequenceAt(n6).getLength() - n7 + 1, n2 - nArray[n5]);
                gappedSequenceArray[n5++] = this.getSequenceAt(n6).getGappedSubSequence(n7, n8);
            }
            ++n6;
        }
        return new DefaultSequenceAlignment(gappedSequenceArray, this.type, nArray);
    }

    public SequenceType getSequenceType() {
        return this.type;
    }

    public GappedSequence getSequenceAt(int n) {
        try {
            return (GappedSequence)this.msa.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchSequenceException("The index " + n + " is out of bounds", this, n);
        }
    }

    public int getSequenceIndex(GappedSequence gappedSequence) {
        int n = 0;
        while (n < this.msa.size()) {
            if ((GappedSequence)this.msa.get(n) == gappedSequence) {
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    protected void setLengthQuietly(int n) {
        this.length = n;
    }

    protected void addSequenceQuietly(GappedSequence gappedSequence, int n) {
        if (gappedSequence.getSequenceType() != this.type) {
            throw new InvalidSequenceTypeException("All sequences must be of the same type");
        }
        gappedSequence.addSequenceListener(this);
        this.msa.add(gappedSequence);
        this.inset.add(n);
    }

    protected GappedSequence removeSequenceQuietly(int n) {
        GappedSequence gappedSequence = null;
        try {
            gappedSequence = (GappedSequence)this.msa.remove(n - 1);
            this.inset.remove(n - 1);
            gappedSequence.removeSequenceListener(this);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchSequenceException(this, n);
        }
        return gappedSequence;
    }

    protected void setInsetQuietly(int n, int n2) {
        try {
            this.inset.set(n - 1, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchSequenceException(this, n);
        }
    }

    public int getInset(int n) {
        try {
            return this.inset.get(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchSequenceException(this, n);
        }
    }

    public int getNumberSequences() {
        return this.msa.size();
    }

    public int getLength() {
        return this.length;
    }

    public Identifier getIdentifier() {
        return this.ident;
    }
}

