/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoSuchSequenceException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;

public class AlignmentColumn {
    private SequenceAlignment alignment;
    private int column = 1;

    public AlignmentColumn() {
    }

    public AlignmentColumn(SequenceAlignment sequenceAlignment) {
        this();
        this.setAlignment(sequenceAlignment);
    }

    public void setAlignment(SequenceAlignment sequenceAlignment) {
        this.alignment = sequenceAlignment;
    }

    public SequenceAlignment getAlignment() {
        return this.alignment;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public int getColumn() {
        return this.column;
    }

    public Element getElementAtRow(int n) throws NoSuchSequenceException, IllegalStateException {
        try {
            int n2 = this.alignment.getNumberSequences();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("No alignment given");
        }
        int n3 = this.alignment.getInset(n);
        if (this.column < n3 + 1) {
            return Gap.GAP;
        }
        GappedSequence gappedSequence = this.alignment.getSequenceAt(n);
        if (this.column > gappedSequence.getGappedLength() + n3) {
            return Gap.GAP;
        }
        return gappedSequence.getGappedElementAt(this.column - n3);
    }
}

