/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.alignment;

import uk.ac.man.bioinf.sequence.AbstractMutableSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.NoSuchSequenceElementException;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.event.SequenceEventType;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;

public abstract class AbstractGappedSequence
extends AbstractMutableSequence
implements GappedSequence {
    public AbstractGappedSequence(SequenceType sequenceType) {
        super(sequenceType);
    }

    protected abstract void insertGapAtQuietly(int var1);

    public void insertGapAt(int n) throws SequenceVetoException {
        boolean bl = this.hasListeners();
        if (bl) {
            VetoableSequenceEvent vetoableSequenceEvent = new VetoableSequenceEvent(this, n, SequenceEventType.GAPINSERT);
            this.fireVetoableSequenceEvent(vetoableSequenceEvent);
            this.insertGapAtQuietly(n);
            this.fireSequenceEvent(vetoableSequenceEvent);
        } else {
            this.insertGapAtQuietly(n);
        }
    }

    public void insertGapAt(int n, int n2) throws SequenceVetoException {
        boolean bl = this.hasListeners();
        if (bl) {
            VetoableSequenceEvent vetoableSequenceEvent = new VetoableSequenceEvent(this, n, n2, SequenceEventType.GAPINSERT);
            this.fireVetoableSequenceEvent(vetoableSequenceEvent);
            int n3 = 0;
            while (n3 < n2) {
                this.insertGapAtQuietly(n + n3);
                ++n3;
            }
            this.fireSequenceEvent(vetoableSequenceEvent);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.insertGapAtQuietly(n + n4);
                ++n4;
            }
        }
    }

    protected abstract void deleteGapAtQuietly(int var1);

    public void deleteGapAt(int n) throws SequenceVetoException {
        this.deleteGapAt(n, 1);
    }

    public void deleteGapAt(int n, int n2) throws SequenceVetoException {
        boolean bl = this.hasListeners();
        if (bl) {
            VetoableSequenceEvent vetoableSequenceEvent = new VetoableSequenceEvent(this, n, n2, SequenceEventType.GAPDELETE);
            this.fireVetoableSequenceEvent(vetoableSequenceEvent);
            int n3 = 0;
            while (n3 < n2) {
                this.deleteGapAtQuietly(n);
                ++n3;
            }
            this.fireSequenceEvent(vetoableSequenceEvent);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.deleteGapAtQuietly(n + n4);
                ++n4;
            }
        }
    }

    public char getGappedElementAtAsChar(int n) {
        return this.getGappedElementAt(n).toChar();
    }

    public char[] getGappedSequenceAsChars() {
        char[] cArray = new char[this.getGappedLength()];
        Element[] elementArray = this.getGappedSequenceAsElements();
        int n = 0;
        while (n < elementArray.length) {
            cArray[n] = elementArray[n].toChar();
            ++n;
        }
        return cArray;
    }

    protected void checkGappedRange(int n) {
        if (n < 1 || n > this.getGappedLength()) {
            throw this.getGappedSequenceIndexException(n);
        }
    }

    protected void checkGappedRangeForInsert(int n) {
        if (n < 1 || n > this.getGappedLength() + 1) {
            throw new NoSuchSequenceElementException("Attempt to insert gapped element " + n + " in sequence " + this + " illegally");
        }
    }

    protected NoSuchSequenceElementException getGappedSequenceIndexException(int n) {
        return new NoSuchSequenceElementException("Attempt to access gapped element " + n + " in sequence " + this + " which doesnt exist");
    }
}

