/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence;

import uk.ac.man.bioinf.sequence.DefaultSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.types.AminoAcid;
import uk.ac.man.bioinf.sequence.types.DNANucleotide;
import uk.ac.man.bioinf.sequence.types.DNASequenceType;
import uk.ac.man.bioinf.sequence.types.ProteinSequenceType;

public class SequenceFactory {
    protected static AminoAcid[] aa;

    public static Sequence getProteinSequence(char[] cArray) throws InvalidSequenceTypeException {
        Element[] elementArray = new Element[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            try {
                elementArray[n] = aa[Character.toUpperCase(cArray[n]) - 65];
                if (elementArray[n] == null) {
                    throw new InvalidSequenceTypeException("No char " + cArray[n]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(cArray[n] - 65);
                throw new InvalidSequenceTypeException("No char " + cArray[n]);
            }
            ++n;
        }
        return new DefaultSequence(elementArray, (SequenceType)ProteinSequenceType.getInstance());
    }

    public static Sequence getProteinSequence(String string) throws InvalidSequenceTypeException {
        Element[] elementArray = new Element[string.length()];
        int n = 0;
        while (n < string.length()) {
            try {
                elementArray[n] = aa[Character.toUpperCase(string.charAt(n)) - 65];
                if (elementArray[n] == null) {
                    throw new InvalidSequenceTypeException("No char " + string.charAt(n));
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(string.charAt(n) - 65);
                throw new InvalidSequenceTypeException("No char " + string.charAt(n));
            }
            ++n;
        }
        return new DefaultSequence(elementArray, (SequenceType)ProteinSequenceType.getInstance());
    }

    public static Sequence getDNASequence(char[] cArray) throws InvalidSequenceTypeException {
        Element[] elementArray = new Element[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            switch (Character.toUpperCase(cArray[n])) {
                case 'A': {
                    elementArray[n] = DNANucleotide.ADENOSINE;
                    break;
                }
                case 'C': {
                    elementArray[n] = DNANucleotide.CYTOSINE;
                    break;
                }
                case 'G': {
                    elementArray[n] = DNANucleotide.GUANINE;
                    break;
                }
                case 'T': {
                    elementArray[n] = DNANucleotide.THIAMINE;
                    break;
                }
                default: {
                    throw new InvalidSequenceTypeException("Letter " + cArray[n] + " is not a valid part of a DNA Sequence");
                }
            }
            ++n;
        }
        return new DefaultSequence(elementArray, (SequenceType)DNASequenceType.getInstance());
    }

    public static Sequence getDNASequence(String string) throws InvalidSequenceTypeException {
        return SequenceFactory.getDNASequence(string.toCharArray());
    }

    static {
        AminoAcid[] aminoAcidArray = AminoAcid.getAll();
        aa = new AminoAcid[26];
        int n = 0;
        while (n < aminoAcidArray.length) {
            SequenceFactory.aa[aminoAcidArray[n].toChar() - 65] = aminoAcidArray[n];
            ++n;
        }
    }
}

