/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence;

import uk.ac.man.bioinf.sequence.AbstractSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;

public class DefaultSequence
extends AbstractSequence {
    private Element[] elements;
    private Identifier ident;

    public DefaultSequence(Element[] elementArray, SequenceType sequenceType, Identifier identifier) {
        super(sequenceType);
        this.checkSequenceType(elementArray);
        this.elements = elementArray;
        this.ident = identifier;
    }

    public DefaultSequence(Element[] elementArray, SequenceType sequenceType) {
        this(elementArray, sequenceType, new NoIdentifier());
    }

    public DefaultSequence(Sequence sequence, SequenceType sequenceType) {
        this(sequence.getSequenceAsElements(), sequenceType);
    }

    public DefaultSequence(Sequence sequence) {
        this(sequence.getSequenceAsElements(), sequence.getSequenceType());
    }

    public Identifier getIdentifier() {
        return this.ident;
    }

    public int getLength() {
        return this.elements.length;
    }

    public Element getElementAt(int n) {
        try {
            return this.elements[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.getSequenceIndexException(n);
        }
    }

    public Element[] getSequenceAsElements() {
        return (Element[])this.elements.clone();
    }
}

