/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence;

import uk.ac.man.bioinf.sequence.DefaultSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.InvalidSequenceTypeException;
import uk.ac.man.bioinf.sequence.NoSuchSequenceElementException;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.SequenceType;

public abstract class AbstractSequence
implements Sequence {
    private SequenceType type;

    public AbstractSequence(SequenceType sequenceType) {
        this.type = sequenceType;
    }

    public SequenceType getSequenceType() {
        return this.type;
    }

    public Sequence getSubSequence(int n, int n2) {
        this.checkRange(n);
        this.checkRange(n + n2 - 1);
        int n3 = n + n2;
        Element[] elementArray = new Element[n2];
        int n4 = n;
        while (n4 < n3) {
            elementArray[n4 - n] = this.getElementAt(n4);
            ++n4;
        }
        return new DefaultSequence(elementArray, this.getSequenceType());
    }

    public char[] getSequenceAsChars() {
        Element[] elementArray = this.getSequenceAsElements();
        char[] cArray = new char[elementArray.length];
        SequenceType sequenceType = this.getSequenceType();
        int n = 0;
        while (n < elementArray.length) {
            cArray[n] = elementArray[n].toChar();
            ++n;
        }
        return cArray;
    }

    public char getElementAtAsChar(int n) {
        return this.getElementAt(n).toChar();
    }

    protected void checkSequenceType(Element[] elementArray) throws InvalidSequenceTypeException {
        int n = 0;
        while (n < elementArray.length) {
            if (!this.type.isElement(elementArray[n])) {
                throw new InvalidSequenceTypeException("Element " + elementArray[n] + " at " + (n + 1) + " is not part of the sequence type " + this.type.toString());
            }
            ++n;
        }
    }

    protected InvalidSequenceTypeException getSequenceTypeException(Element element) {
        return new InvalidSequenceTypeException("Element " + element + " is not part of the sequence type " + this.type.toString());
    }

    protected void checkSequenceType(Element element) throws InvalidSequenceTypeException {
        if (!this.type.isElement(element)) {
            throw this.getSequenceTypeException(element);
        }
    }

    protected NoSuchSequenceElementException getSequenceIndexException(int n) {
        return new NoSuchSequenceElementException("Attempt to access element at " + n + " in sequence " + this + " which does not exist");
    }

    protected void checkRange(int n) {
        if (n < 1 || n > this.getLength()) {
            throw this.getSequenceIndexException(n);
        }
    }
}

