/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import uk.ac.man.bioinf.io.AlignmentOutputParser;
import uk.ac.man.bioinf.io.InvalidSequenceTypeParserException;
import uk.ac.man.bioinf.io.ParserExceptionHandler;
import uk.ac.man.bioinf.io.SequenceWriterException;
import uk.ac.man.bioinf.io.parsers.AbstractProteinAlignmentInputParser;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.DefaultSequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.NoIdentifier;
import uk.ac.man.bioinf.sequence.types.ProteinSequenceType;
import uk.ac.man.bioinf.util.IntArrayList;

public class PIRProteinAlignmentParser
extends AbstractProteinAlignmentInputParser
implements AlignmentOutputParser {
    public SequenceAlignment parse(Reader reader, ParserExceptionHandler parserExceptionHandler) throws IOException {
        return this.parse(new NoIdentifier(), reader, parserExceptionHandler);
    }

    public SequenceAlignment parse(Identifier identifier, Reader reader, ParserExceptionHandler parserExceptionHandler) throws IOException {
        String string;
        ArrayList<GappedSequence> arrayList = new ArrayList<GappedSequence>();
        IntArrayList intArrayList = new IntArrayList();
        String string2 = "";
        String string3 = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + stringTokenizer.nextToken();
            }
            string = string4;
            if (string.startsWith(">P1;")) {
                string3 = "";
                string2 = string.substring(4);
                string = bufferedReader.readLine();
                if (string == "") continue;
                string2 = string2 + " [" + string + "]";
                continue;
            }
            if (string.endsWith("*")) {
                if ((string3 = string3 + string.substring(0, string.length() - 1)) == "") continue;
                GappedSequence gappedSequence = this.toSequence(string3, string2, parserExceptionHandler);
                try {
                    intArrayList.add(Sequences.chompLeadingGaps(gappedSequence));
                }
                catch (SequenceVetoException sequenceVetoException) {
                    // empty catch block
                }
                arrayList.add(gappedSequence);
                continue;
            }
            string3 = string3 + string;
        }
        GappedSequence[] gappedSequenceArray = new GappedSequence[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, gappedSequenceArray, 0, gappedSequenceArray.length);
        return new DefaultSequenceAlignment(gappedSequenceArray, ProteinSequenceType.getInstance(), intArrayList.toArray(), identifier);
    }

    public Writer write(SequenceAlignment sequenceAlignment, Writer writer, ParserExceptionHandler parserExceptionHandler) {
        if (sequenceAlignment.getSequenceType() != ProteinSequenceType.getInstance()) {
            parserExceptionHandler.handleException(new InvalidSequenceTypeParserException(ProteinSequenceType.getInstance()));
        }
        int n = 0;
        while (n < sequenceAlignment.getNumberSequences()) {
            GappedSequence gappedSequence = sequenceAlignment.getSequenceAt(n + 1);
            String string = "";
            int n2 = 0;
            while (n2 < sequenceAlignment.getInset(n + 1)) {
                string = string + "" + Gap.GAP.toChar() + "";
                ++n2;
            }
            String string2 = string + Sequences.getGappedSequenceAsString(gappedSequence);
            String string3 = gappedSequence.getIdentifier().getTitle();
            String string4 = gappedSequence.getIdentifier().getSource().getTitle();
            if (string3 == "") {
                string3 = "Unknown protein";
            }
            if (string4 == "" || string4 == "No Title") {
                string4 = "Unknown source";
            }
            try {
                writer.write(">P1;" + string3 + "\n");
                writer.write("From: " + string4 + "\n");
                int n3 = 0;
                while (n3 < string2.length()) {
                    writer.write(string2.charAt(n3));
                    if ((n3 + 1) % 80 == 0) {
                        writer.write("\n");
                    }
                    ++n3;
                }
                writer.write("*\n");
            }
            catch (IOException iOException) {
                parserExceptionHandler.handleException(new SequenceWriterException());
            }
            ++n;
        }
        return writer;
    }

    public String getDescription() {
        return "PIR/NBRF protein sequence parser";
    }
}

