/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import uk.ac.man.bioinf.io.ParserExceptionHandler;
import uk.ac.man.bioinf.io.parsers.AbstractProteinSequenceInputParser;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.identifier.Identifier;
import uk.ac.man.bioinf.sequence.identifier.SimpleIdentifier;

public class FastaSequenceParser
extends AbstractProteinSequenceInputParser {
    public Sequence parse(Reader reader, ParserExceptionHandler parserExceptionHandler) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null && !string.startsWith(">")) {
        }
        return this.parseSequence(new SimpleIdentifier(string), bufferedReader, parserExceptionHandler);
    }

    public Sequence parse(Identifier identifier, Reader reader, ParserExceptionHandler parserExceptionHandler) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while (!(string = bufferedReader.readLine()).startsWith(">")) {
        }
        return this.parseSequence(identifier, bufferedReader, parserExceptionHandler);
    }

    private Sequence parseSequence(Identifier identifier, BufferedReader bufferedReader, ParserExceptionHandler parserExceptionHandler) throws IOException {
        String string;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).endsWith("*")) {
                bl = false;
                string = string.substring(0, string.length() - 2);
            }
            stringBuffer.append(string);
        }
        return this.toSequence(identifier, stringBuffer.toString(), parserExceptionHandler);
    }

    public String getDescription() {
        return "Fasta format parser";
    }
}

